/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jpt.common.core.internal.utility.ContentTypeTools;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.JaxbProjectManager;
import org.eclipse.jpt.jaxb.core.JaxbWorkspace;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.ui.JaxbWorkbench;
import org.eclipse.jpt.jaxb.ui.internal.plugin.JptJaxbUiPlugin;

public class JaxbJavaCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    public void sessionStarted() {
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return context instanceof JavaContentAssistInvocationContext ? this.computeCompletionProposals((JavaContentAssistInvocationContext)context) : Collections.emptyList();
    }

    private List<ICompletionProposal> computeCompletionProposals(JavaContentAssistInvocationContext context) {
        try {
            return this.computeCompletionProposals_(context);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    private List<ICompletionProposal> computeCompletionProposals_(JavaContentAssistInvocationContext context) {
        IContentType contentType;
        ICompilationUnit cu = context.getCompilationUnit();
        IFile file = cu != null ? this.getCorrespondingResource(cu) : null;
        IContentType iContentType = contentType = file != null ? ContentTypeTools.contentType((IFile)file) : null;
        if (contentType == null || !contentType.isKindOf(JavaResourceCompilationUnit.CONTENT_TYPE)) {
            return Collections.emptyList();
        }
        JaxbProject jaxbProject = this.getJaxbProject(file.getProject());
        if (jaxbProject == null) {
            return Collections.emptyList();
        }
        Iterable javaNodes = jaxbProject.getPrimaryJavaNodes(cu);
        if (IterableTools.isEmpty((Iterable)javaNodes)) {
            return Collections.emptyList();
        }
        CompletionContext cc = context.getCoreContext();
        char[] prefix = cc.getToken();
        Predicate<String> filter = this.buildPrefixFilter(prefix);
        int tokenKind = cc.getTokenKind();
        int tokenStart = cc.getTokenStart();
        int tokenEnd = cc.getTokenEnd();
        if (tokenStart == -1) {
            return Collections.emptyList();
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (JaxbContextNode javaNode : javaNodes) {
            for (String proposal : this.buildCompletionProposals(javaNode, context.getInvocationOffset(), filter)) {
                if (tokenKind == 2) {
                    proposals.add((ICompletionProposal)new CompletionProposal(proposal, tokenStart + 1, tokenEnd - tokenStart - 1, proposal.length()));
                    continue;
                }
                proposals.add((ICompletionProposal)new CompletionProposal("\"" + proposal + "\"", tokenStart, tokenEnd - tokenStart + 1, proposal.length() + 2));
            }
        }
        return proposals;
    }

    private Iterable<String> buildCompletionProposals(JaxbContextNode javaNode, int pos, Predicate<String> filter) {
        return IterableTools.filter((Iterable)javaNode.getCompletionProposals(pos), filter);
    }

    private IFile getCorrespondingResource(ICompilationUnit cu) {
        try {
            return (IFile)cu.getCorrespondingResource();
        }
        catch (JavaModelException ex) {
            JptJaxbUiPlugin.instance().logError(ex);
            return null;
        }
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    private JaxbProject getJaxbProject(IProject project) {
        JaxbProjectManager jaxbProjectManager = this.getJaxbProjectManager();
        return jaxbProjectManager == null ? null : jaxbProjectManager.getJaxbProject(project);
    }

    private JaxbProjectManager getJaxbProjectManager() {
        JaxbWorkspace jaxbWorkspace = this.getJaxbWorkspace();
        return jaxbWorkspace == null ? null : jaxbWorkspace.getJaxbProjectManager();
    }

    private JaxbWorkspace getJaxbWorkspace() {
        JaxbWorkbench jaxbWorkbench = this.getJaxbWorkbench();
        return jaxbWorkbench == null ? null : jaxbWorkbench.getJaxbWorkspace();
    }

    private JaxbWorkbench getJaxbWorkbench() {
        return (JaxbWorkbench)WorkbenchTools.getAdapter(JaxbWorkbench.class);
    }

    private Predicate<String> buildPrefixFilter(char[] prefix) {
        return prefix == null ? PredicateTools.true_() : new StringTools.StartsWithIgnoreCase(new String(prefix));
    }
}

