/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.internal.operations;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.j2ee.ejb.internal.operations.CreateEnterpriseBeanTemplateModel;
import org.eclipse.jst.j2ee.ejb.internal.operations.DestinationType;
import org.eclipse.jst.j2ee.internal.common.operations.Method;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateMessageDrivenBeanTemplateModel
extends CreateEnterpriseBeanTemplateModel {
    public static final String QUALIFIED_ACTIVATION_CONFIG_PROPERTY = "javax.ejb.ActivationConfigProperty";
    public static final String QUALIFIED_TRANSACTION_MANAGEMENT = "javax.ejb.TransactionManagement";
    public static final String QUALIFIED_TRANSACTION_MANAGEMENT_TYPE = "javax.ejb.TransactionManagementType";
    public static final String QUALIFIED_JSM_MESSAGE = "javax.jms.Message";
    public static final String QUALIFIED_MESSAGE_DRIVEN = "javax.ejb.MessageDriven";
    public static final String ATT_ACTIVATION_CONFIG = "activationConfig";
    public static final String ATT_MESSAGE_LISTENER_INTERFACE = "messageListenerInterface";
    public static final String ON_MESSAGE = "onMessage";
    public static final String ON_MESSAGE_SIGNATURE = "(Ljavax/jms/Message;)V";
    public static final String PROP_DESTINATION_TYPE = "destinationType";
    public static final String PROP_DESTINATION = "destination";
    private static final String CLASS_SUFFIX = ".class";

    public CreateMessageDrivenBeanTemplateModel(IDataModel dataModel) {
        super(dataModel);
    }

    public Collection<String> getImports() {
        Collection collection = super.getImports();
        collection.add(QUALIFIED_MESSAGE_DRIVEN);
        if (this.isJMS()) {
            collection.add(QUALIFIED_ACTIVATION_CONFIG_PROPERTY);
            collection.add("javax.jms.MessageListener");
            collection.add(QUALIFIED_JSM_MESSAGE);
        }
        if (!this.isContainerType()) {
            collection.add(QUALIFIED_TRANSACTION_MANAGEMENT);
            collection.add(QUALIFIED_TRANSACTION_MANAGEMENT_TYPE);
        }
        collection.add(this.dataModel.getStringProperty("INewMessageDrivenBeanClassDataModelProperties.MESSAGE_LISTENER_INTERFACE"));
        return collection;
    }

    public Map<String, Object> getClassAnnotationParams() {
        String mappedName;
        String dispName;
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, String> activationConfigProperties = new HashMap<String, String>();
        result.put(ATT_ACTIVATION_CONFIG, activationConfigProperties);
        if (this.isJMS()) {
            String destinationType = this.dataModel.getStringProperty("INewMessageDrivenBeanClassDataModelProperties.DESTINATION_TYPE");
            if (destinationType.equals(DestinationType.QUEUE.toString())) {
                activationConfigProperties.put(PROP_DESTINATION_TYPE, "javax.jms.Queue");
            } else if (destinationType.equals(DestinationType.TOPIC.toString())) {
                activationConfigProperties.put(PROP_DESTINATION_TYPE, "javax.jms.Topic");
            } else {
                throw new IllegalStateException("illegal destination type: " + destinationType);
            }
        }
        if (!(dispName = this.getProperty("INewEnterpriseBeanClassDataModelProperties.EJB_NAME").trim()).equals(this.getClassName()) && dispName.length() > 0) {
            result.put("name", "\"" + dispName + "\"");
        }
        if ((mappedName = this.getProperty("INewEnterpriseBeanClassDataModelProperties.MAPPED_NAME").trim()) != null && mappedName.length() > 0) {
            result.put("mappedName", "\"" + mappedName + "\"");
            if (this.isJMS()) {
                activationConfigProperties.put(PROP_DESTINATION, mappedName);
            }
        }
        String messageListenerInterface = this.getProperty("INewMessageDrivenBeanClassDataModelProperties.MESSAGE_LISTENER_INTERFACE");
        List interfaces = this.getQualifiedInterfaces();
        if (interfaces.size() != 1 || !interfaces.contains(messageListenerInterface)) {
            result.put(ATT_MESSAGE_LISTENER_INTERFACE, String.valueOf(Signature.getSimpleName((String)messageListenerInterface)) + CLASS_SUFFIX);
        }
        return result;
    }

    public boolean isJMS() {
        return this.dataModel.getBooleanProperty("INewMessageDrivenBeanClassDataModelProperties.JMS");
    }

    public Collection<Method> getUnimplementedMethods() {
        Collection unimplementedMethods = super.getUnimplementedMethods();
        Iterator iterator = unimplementedMethods.iterator();
        while (iterator.hasNext()) {
            Method method = (Method)iterator.next();
            if (!ON_MESSAGE.equals(method.getName()) || !ON_MESSAGE_SIGNATURE.equals(method.getSignature())) continue;
            iterator.remove();
        }
        return unimplementedMethods;
    }
}

