/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.section;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacetNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacetType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.dialog.AddEditFacetDialog;
import org.eclipse.jst.jsf.facesconfig.ui.page.IFacesConfigPage;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractFacesConfigSection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FacetSection
extends AbstractFacesConfigSection {
    private static final int TABLE_DEFAULT_HEIGHT = 160;
    private TableViewer tableViewer;
    private Button removeButton;
    private Button editButton;

    public FacetSection(Composite parent, IManagedForm managedForm, IFacesConfigPage page, FormToolkit toolkit) {
        super(parent, managedForm, page, toolkit, null, null);
        this.getSection().setText(EditorMessages.FacetSection_Name);
        this.getSection().setDescription(EditorMessages.FacetSection_Description);
    }

    protected void createContents(Composite container, FormToolkit toolkit) {
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        container.setLayout((Layout)gl);
        GridData td = new GridData(1808);
        container.setLayoutData((Object)td);
        toolkit.paintBordersFor(container);
        Composite facetSection = toolkit.createComposite(container);
        GridLayout gl2 = new GridLayout();
        gl2.horizontalSpacing = 0;
        gl2.marginWidth = 0;
        gl2.numColumns = 2;
        facetSection.setLayout((Layout)gl2);
        GridData gd = new GridData(1810);
        facetSection.setLayoutData((Object)gd);
        this.createTableSection(facetSection, toolkit);
        this.createButtonsSection(facetSection, toolkit);
    }

    private void createTableSection(Composite container, FormToolkit toolkit) {
        Composite tableContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1808);
        tableContainer.setLayoutData((Object)gd);
        toolkit.paintBordersFor(tableContainer);
        GridLayout gl = new GridLayout();
        tableContainer.setLayout((Layout)gl);
        Table table = new Table(tableContainer, 68352);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 160;
        table.setLayoutData((Object)gd);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        TableColumn facetNameCol = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        facetNameCol.setText(EditorMessages.FacetSection_Table_FacetNameColumn);
        TableColumn displayNameCol = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        displayNameCol.setText(EditorMessages.FacetSection_Table_DisplayNameColumn);
        TableColumn descriptionCol = new TableColumn(table, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        descriptionCol.setText(EditorMessages.FacetSection_Table_DescriptionColumn);
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetSection.this.updateButtons();
            }
        });
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (((IStructuredSelection)FacetSection.this.tableViewer.getSelection()).size() > 0) {
                    FacetSection.this.editButtonSelected();
                }
            }
        });
        this.tableViewer = new TableViewer(table);
        this.tableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.getAdapterFactory()));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.getAdapterFactory()));
        this.tableViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return FacesConfigPackage.eINSTANCE.getFacetType().isInstance(element);
            }
        });
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void createButtonsSection(Composite container, FormToolkit toolkit) {
        Composite operationContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1042);
        operationContainer.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        operationContainer.setLayout((Layout)gl);
        Button addButton = toolkit.createButton(operationContainer, EditorMessages.UI_Button_Add_more, 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        addButton.setLayoutData((Object)gd);
        this.editButton = toolkit.createButton(operationContainer, EditorMessages.UI_Button_Edit_more, 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.editButton.setLayoutData((Object)gd);
        this.removeButton = toolkit.createButton(operationContainer, EditorMessages.UI_Button_Remove, 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.removeButton.setLayoutData((Object)gd);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetSection.this.addButtonSelected();
            }
        });
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetSection.this.editButtonSelected();
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FacetSection.this.removeButtonSelected();
            }
        });
    }

    public void refresh() {
        super.refresh();
        this.tableViewer.refresh();
        this.updateButtons();
    }

    public void refreshAll() {
        this.tableViewer.setInput(this.getInput());
        this.updateButtons();
    }

    private void updateButtons() {
        if (((IStructuredSelection)this.tableViewer.getSelection()).size() > 0) {
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
    }

    private void addButtonSelected() {
        Shell shell = EditorPlugin.getActiveShell();
        AddEditFacetDialog dialog = new AddEditFacetDialog(shell, true);
        if (dialog.open() == 0) {
            Command addCommand;
            String newFacetName = dialog.getFacetName();
            String newDisplayName = dialog.getDisplayName();
            String newDescription = dialog.getDescription();
            FacetType newFacet = FacesConfigFactory.eINSTANCE.createFacetType();
            if (newFacetName.length() > 0) {
                FacetNameType facetNameType = FacesConfigFactory.eINSTANCE.createFacetNameType();
                facetNameType.setTextContent(newFacetName);
                newFacet.setFacetName(facetNameType);
            }
            if (newDisplayName.length() > 0) {
                DisplayNameType displayNameType = FacesConfigFactory.eINSTANCE.createDisplayNameType();
                displayNameType.setTextContent(newDisplayName);
                newFacet.getDisplayName().add((Object)displayNameType);
            }
            if (newDescription.length() > 0) {
                DescriptionType descriptionType = FacesConfigFactory.eINSTANCE.createDescriptionType();
                descriptionType.setTextContent(newDescription);
                newFacet.getDescription().add((Object)descriptionType);
            }
            if ((addCommand = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getInput(), (Object)FacesConfigPackage.eINSTANCE.getComponentType_Facet(), (Object)newFacet)).canExecute()) {
                this.getEditingDomain().getCommandStack().execute(addCommand);
            }
        }
    }

    private void editButtonSelected() {
        FacetType facet = (FacetType)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        Assert.isNotNull((Object)facet);
        Shell shell = EditorPlugin.getActiveShell();
        AddEditFacetDialog dialog = new AddEditFacetDialog(shell, false);
        if (facet.getFacetName() != null) {
            dialog.setFacetName(facet.getFacetName().getTextContent());
        }
        if (facet.getDisplayName().size() > 0) {
            dialog.setDisplayName(((DisplayNameType)facet.getDisplayName().get(0)).getTextContent());
        }
        if (facet.getDescription().size() > 0) {
            dialog.setDescription(((DescriptionType)facet.getDescription().get(0)).getTextContent());
        }
        if (dialog.open() == 0) {
            ArrayList<Command> commands = new ArrayList<Command>(3);
            String newFacetName = dialog.getFacetName();
            String newDisplayName = dialog.getDisplayName();
            String newDescription = dialog.getDescription();
            if (facet.getFacetName() != null) {
                Command cmd1 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)facet.getFacetName(), (Object)FacesConfigPackage.eINSTANCE.getFacetNameType_TextContent(), (Object)newFacetName);
                commands.add(cmd1);
            } else if (newFacetName.length() > 0) {
                FacetNameType newFacetNameType = FacesConfigFactory.eINSTANCE.createFacetNameType();
                newFacetNameType.setTextContent(newFacetName);
                Command cmd2 = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)facet, (Object)FacesConfigPackage.eINSTANCE.getFacetType_FacetName(), (Object)newFacetNameType);
                commands.add(cmd2);
            }
            if (facet.getDisplayName().size() > 0) {
                DisplayNameType displayNameType = (DisplayNameType)facet.getDisplayName().get(0);
                Command cmd3 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)displayNameType, (Object)FacesConfigPackage.eINSTANCE.getDisplayNameType_TextContent(), (Object)newDisplayName);
                commands.add(cmd3);
            } else if (newDisplayName.length() > 0) {
                DisplayNameType newDisplayNameType = FacesConfigFactory.eINSTANCE.createDisplayNameType();
                newDisplayNameType.setTextContent(newDisplayName);
                Command cmd4 = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)facet, (Object)FacesConfigPackage.eINSTANCE.getFacetType_DisplayName(), (Object)newDisplayNameType);
                commands.add(cmd4);
            }
            if (facet.getDescription().size() > 0) {
                DescriptionType descriptionType = (DescriptionType)facet.getDescription().get(0);
                Command cmd5 = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)descriptionType, (Object)FacesConfigPackage.eINSTANCE.getDescriptionType_TextContent(), (Object)newDescription);
                commands.add(cmd5);
            } else if (newDescription.length() > 0) {
                DescriptionType newDescriptionType = FacesConfigFactory.eINSTANCE.createDescriptionType();
                newDescriptionType.setTextContent(newDescription);
                Command cmd6 = AddCommand.create((EditingDomain)this.getEditingDomain(), (Object)facet, (Object)FacesConfigPackage.eINSTANCE.getFacetType_Description(), (Object)newDescriptionType);
                commands.add(cmd6);
            }
            CompoundCommand command = new CompoundCommand(commands);
            if (command.canExecute()) {
                this.getEditingDomain().getCommandStack().execute((Command)command);
                this.tableViewer.refresh((Object)facet);
            }
        }
    }

    private void removeButtonSelected() {
        FacetType facet = (FacetType)((IStructuredSelection)this.tableViewer.getSelection()).getFirstElement();
        Assert.isNotNull((Object)facet);
        Command removeCommand = RemoveCommand.create((EditingDomain)this.getEditingDomain(), (Object)this.getInput(), (Object)FacesConfigPackage.eINSTANCE.getComponentType_Facet(), (Object)facet);
        if (removeCommand.canExecute()) {
            this.getEditingDomain().getCommandStack().execute(removeCommand);
            this.refreshAll();
        }
    }

    public ISelection getSelection() {
        return this.tableViewer.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.tableViewer.setSelection(selection);
    }
}

