/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IImageDescriptorProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfo;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfos;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.swt.graphics.Image;

public class TagImageManager {
    private static final String PALETTE_DEFAULT_IMAGE_FILE = "palette/GENERIC/large/PD_Palette_Default.gif";
    private static TagImageManager INSTANCE = null;
    private static final ImageDescriptor DEFAULT_SMALL_ICON = JSFUICommonPlugin.getDefault().getImageDescriptor("PD_Palette_Default.gif");
    private static final ImageDescriptor DEFAULT_LARGE_ICON = PDPlugin.getDefault().getImageDescriptor("palette/GENERIC/large/PD_Palette_Default.gif");
    private static final String TRAIT_ICON_SMALL = "small-icon";
    private static final String TRAIT_ICON_LARGE = "large-icon";

    public static synchronized TagImageManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TagImageManager();
        }
        return INSTANCE;
    }

    public Image getSmallIconImage(IFile file, String nsUri, String tagName) {
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(file);
        return this.getImage(context, nsUri, tagName, true);
    }

    public Image getSmallIconImage(IProject project, String nsUri, String tagName) {
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(project);
        return this.getImage(context, nsUri, tagName, true);
    }

    public Image getLargeIconImage(IFile file, String nsUri, String tagName) {
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(file);
        return this.getImage(context, nsUri, tagName, false);
    }

    public Image getLargeIconImage(IProject project, String nsUri, String tagName) {
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(project);
        return this.getImage(context, nsUri, tagName, false);
    }

    private Image getImage(IMetaDataDomainContext context, String nsUri, String tagName, boolean getSmallImage) {
        Image image = null;
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        Model model = this.getModel(query, nsUri);
        if (model != null) {
            ImageDescriptor imgDesc = this.getIconImageDescriptor(query, model, tagName, getSmallImage);
            image = TagImageManager.getOrCreateImage(imgDesc);
        }
        return image;
    }

    public static Image getOrCreateImage(ImageDescriptor imageDescriptor) {
        Image image = null;
        if (imageDescriptor != null) {
            image = PDPlugin.getDefault().getImageRegistry().get(imageDescriptor.toString());
            if (image == null) {
                image = imageDescriptor.createImage();
                PDPlugin.getDefault().getImageRegistry().put(imageDescriptor.toString(), image);
            } else if (image.isDisposed()) {
                PDPlugin.getDefault().getImageRegistry().remove(imageDescriptor.toString());
                image = imageDescriptor.createImage();
                PDPlugin.getDefault().getImageRegistry().put(imageDescriptor.toString(), image);
            }
        }
        return image;
    }

    private Model getModel(ITaglibDomainMetaDataQuery query, String nsUri) {
        return query.findTagLibraryModel(nsUri);
    }

    private ImageDescriptor getIconImageDescriptor(ITaglibDomainMetaDataQuery query, Model model, String tagName, boolean small) {
        ImageDescriptor icon = null;
        Trait trait = query.findTrait((Entity)model, "paletteInfos");
        if (trait != null) {
            PaletteInfos tags = (PaletteInfos)trait.getValue();
            for (PaletteInfo tag : tags.getInfos()) {
                if (!tag.getId().equalsIgnoreCase(tagName)) continue;
                IMetaDataSourceModelProvider sourceProvider = ((Trait)tag.eContainer().eContainer()).getSourceModelProvider();
                if (small) {
                    icon = this.getImageDescriptorFromString(sourceProvider, tag.getSmallIcon(), DEFAULT_SMALL_ICON);
                    break;
                }
                icon = this.getImageDescriptorFromString(sourceProvider, tag.getLargeIcon(), DEFAULT_LARGE_ICON);
                break;
            }
        }
        if (icon == null) {
            for (Entity tagAsEntity : model.getChildEntities()) {
                if (!tagAsEntity.getId().equalsIgnoreCase(tagName)) continue;
                if (small) {
                    icon = this.getImageDescriptorFromTagTraitValueAsString(query, tagAsEntity, TRAIT_ICON_SMALL, DEFAULT_SMALL_ICON);
                    break;
                }
                icon = this.getImageDescriptorFromTagTraitValueAsString(query, tagAsEntity, TRAIT_ICON_LARGE, DEFAULT_LARGE_ICON);
                break;
            }
        }
        return icon;
    }

    private ImageDescriptor getImageDescriptorFromString(IMetaDataSourceModelProvider sourceModelProvider, String imgDesc, ImageDescriptor defaultValue) {
        ImageDescriptor image = defaultValue;
        IImageDescriptorProvider imageProvider = (IImageDescriptorProvider)sourceModelProvider.getAdapter(IImageDescriptorProvider.class);
        if (imageProvider != null) {
            image = imageProvider.getImageDescriptor(imgDesc);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptorFromTagTraitValueAsString(ITaglibDomainMetaDataQuery query, Entity entity, String key, ImageDescriptor defaultValue) {
        Trait t = query.findTrait(entity, key);
        if (t != null) {
            String imgDesc = TraitValueHelper.getValueAsString((Trait)t);
            return this.getImageDescriptorFromString(t.getSourceModelProvider(), imgDesc, defaultValue);
        }
        return defaultValue;
    }
}

