/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.app.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ConcurrentModificationException;
import javax.persistence.PersistenceException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeySequenceText;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jubula.app.core.JubulaWorkbenchWindowAdvisor;
import org.eclipse.jubula.app.i18n.Messages;
import org.eclipse.jubula.client.core.businessprocess.progress.OperationCanceledUtil;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.JBFatalException;
import org.eclipse.jubula.tools.internal.exception.JBRuntimeException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.console.ConsoleView;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JubulaWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static Logger log = LoggerFactory.getLogger(JubulaWorkbenchAdvisor.class);
    private ILogListener m_runtimeLogger = new ILogListener(){

        public void logging(IStatus status, String pluginId) {
            if (status.getException() instanceof RuntimeException) {
                Plugin.getDefault().handleError(status.getException());
            }
        }
    };

    public String getInitialWindowPerspectiveId() {
        return "org.eclipse.jubula.client.ui.rcp.perspectives.SpecificationPerspective";
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
        Bundle ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_OBJ_PROJECT", "icons/full/obj16/prj_obj.png", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_OBJ_PROJECT_CLOSED", "icons/full/obj16/cprj_obj.png", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_ETOOL_PROBLEM_CATEGORY", "icons/full/etool16/problem_category.png", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_OBJS_ERROR_PATH", "icons/full/obj16/error_tsk.png", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_OBJS_WARNING_PATH", "icons/full/obj16/warn_tsk.png", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_OBJS_INFO_PATH", "icons/full/obj16/info_tsk.png", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_ELCL_QUICK_FIX_ENABLED", "icons/full/elcl16/smartmode_co.png", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_DLCL_QUICK_FIX_DISABLED", "icons/full/dlcl16/smartmode_co.png", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_DLGBAN_QUICKFIX_DLG", "icons/full/wizban/quick_fix.png", true);
        this.declareWorkbenchImage(configurer, ideBundle, "IMG_DLGBAN_SAVEAS_DLG", "icons/full/wizban/saveas_wiz.png", true);
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new JubulaWorkbenchWindowAdvisor(configurer);
    }

    public void preStartup() {
        IDE.registerAdapters();
    }

    private void declareWorkbenchImage(IWorkbenchConfigurer configurerP, Bundle ideBundle, String symbolicName, String path, boolean shared) {
        URL url = ideBundle.getEntry(path);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        configurerP.declareImage(symbolicName, desc, shared);
    }

    public IAdaptable getDefaultPageInput() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot();
    }

    public void postStartup() {
        Platform.addLogListener((ILogListener)this.m_runtimeLogger);
    }

    public void eventLoopException(Throwable exception) {
        if (exception instanceof RuntimeException) {
            if (OperationCanceledUtil.isOperationCanceled((RuntimeException)((RuntimeException)exception))) {
                return;
            }
            log.error(Messages.UnhandledRuntimeException, exception);
            if (exception instanceof JBRuntimeException) {
                ErrorHandlingUtil.createMessageDialog((Integer)((JBRuntimeException)exception).getErrorId());
                return;
            }
            if (exception instanceof PersistenceException) {
                ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_UNKNOWN_DB_ERROR);
                return;
            }
            if (exception instanceof IllegalStateException) {
                Location workspace = Platform.getInstanceLocation();
                if (workspace.isSet()) {
                    File workspaceDir = new File(workspace.getURL().getFile());
                    while (workspaceDir != null && !workspaceDir.exists()) {
                        workspaceDir = workspaceDir.getParentFile();
                    }
                    if (workspaceDir == null || !workspaceDir.canWrite()) {
                        String displayDir = this.getWorkspaceLocation();
                        ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_INVALID_WORKSPACE, (Object[])new String[]{displayDir}, null);
                        return;
                    }
                }
            } else {
                StackTraceElement[] stackTraceArray = exception.getStackTrace();
                if (!this.checkStackTrace(exception, stackTraceArray)) {
                    return;
                }
            }
            if (!Plugin.isRCPException((Throwable)exception) && !Plugin.isContentAssistException((Throwable)exception)) {
                ErrorHandlingUtil.createMessageDialog((JBRuntimeException)new JBFatalException(exception, MessageIDs.E_UNEXPECTED_EXCEPTION));
            }
        } else {
            super.eventLoopException(exception);
        }
    }

    private boolean checkStackTrace(Throwable exception, StackTraceElement[] stackTraceArray) {
        int i = 0;
        while (i < stackTraceArray.length) {
            StackTraceElement stackTraceElement = stackTraceArray[i];
            String className = stackTraceElement.getClassName();
            if (exception instanceof IllegalArgumentException && KeySequence.class.getName().equals(className)) {
                return false;
            }
            if (stackTraceElement.toString().contains("mylyn")) {
                if (exception instanceof IllegalArgumentException || exception instanceof ClassCastException || exception instanceof ConcurrentModificationException) {
                    return false;
                }
            } else {
                if (exception instanceof NullPointerException && KeySequenceText.class.getName().equals(className)) {
                    return false;
                }
                if (exception instanceof NullPointerException && className != null && className.startsWith(ConsoleView.class.getName())) {
                    return false;
                }
                if (exception instanceof NullPointerException && Plugin.isGEFException((Throwable)exception)) {
                    return false;
                }
                if (exception instanceof NullPointerException && Plugin.isRCPException((Throwable)exception)) {
                    return false;
                }
                if (exception instanceof NumberFormatException && "org.eclipse.ui.views.ProblemView".equals(this.getActivePartId())) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private String getWorkspaceLocation() {
        String displayDir;
        try {
            displayDir = new File(Platform.getInstanceLocation().getURL().getFile()).getCanonicalPath();
        }
        catch (IOException iOException) {
            displayDir = new File(Platform.getInstanceLocation().getURL().getFile()).getPath();
        }
        return displayDir;
    }

    private String getActivePartId() {
        String emptyString = "";
        IWorkbench wb = PlatformUI.getWorkbench();
        if (wb == null) {
            return emptyString;
        }
        IWorkbenchWindow wbWin = wb.getActiveWorkbenchWindow();
        if (wbWin == null) {
            return emptyString;
        }
        IWorkbenchPage page = wbWin.getActivePage();
        if (page == null) {
            return emptyString;
        }
        IWorkbenchPart part = page.getActivePart();
        if (part == null) {
            return emptyString;
        }
        IWorkbenchPartSite site = part.getSite();
        if (site == null) {
            return emptyString;
        }
        return site.getId();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean preShutdown() {
        block7: {
            try {
                Plugin.getDefault().setClientStatus(Plugin.ClientStatus.STOPPING);
                IWorkbenchWindow[] allWW = PlatformUI.getWorkbench().getWorkbenchWindows();
                if (allWW != null) {
                    int i = 0;
                    while (i < allWW.length) {
                        IWorkbenchPage[] allWP = allWW[i].getPages();
                        if (allWP != null) {
                            int j = 0;
                            while (j < allWP.length) {
                                boolean areAllClosed = allWP[j].closeAllEditors(true);
                                if (!areAllClosed) {
                                    return false;
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
                ResourcesPlugin.getWorkspace().save(true, null);
            }
            catch (CoreException e) {
                if (!log.isErrorEnabled()) break block7;
                log.error(Messages.UnhandledRuntimeException, (Throwable)e);
            }
        }
        Platform.removeLogListener((ILogListener)this.m_runtimeLogger);
        return super.preShutdown();
    }
}

