/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jubula.client.core.businessprocess.CompNameTypeManager;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.rcp.widgets.CompNamesProposal;

public class CompNamesProposalProvider
implements IContentProposalProvider {
    private IComponentNameCache m_compNameCache;
    private String m_typeFilter = "";

    public CompNamesProposalProvider(IComponentNameCache compNameCache) {
        this.m_compNameCache = compNameCache;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<IComponentNamePO> compNamesList = new ArrayList<IComponentNamePO>();
        Long currentProjectId = GeneralStorage.getInstance().getProject() != null ? GeneralStorage.getInstance().getProject().getId() : null;
        String subString = position == 0 ? contents : contents.substring(0, position);
        for (IComponentNamePO cN : this.m_compNameCache.getAllCompNamePOs()) {
            if (StringUtils.isEmpty((String)cN.getName()) || !cN.getName().startsWith(subString) || cN.getParentProjectId() == null || !cN.getParentProjectId().equals(currentProjectId) || !CompNameTypeManager.mayBeCompatible((IComponentNamePO)cN, (String)this.m_typeFilter)) continue;
            compNamesList.add(cN);
        }
        Collections.sort(compNamesList, new JBComparator());
        ArrayList<CompNamesProposal> proposals = new ArrayList<CompNamesProposal>(compNamesList.size());
        for (IComponentNamePO data : compNamesList) {
            proposals.add(new CompNamesProposal(data));
        }
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    public void setTypeFilter(String typeFilter) {
        this.m_typeFilter = typeFilter;
    }

    public void setComponentNameCache(IComponentNameCache compNameCache) {
        this.m_compNameCache = compNameCache;
    }

    private class JBComparator
    implements Comparator<IComponentNamePO> {
        private JBComparator() {
        }

        @Override
        public int compare(IComponentNamePO element0, IComponentNamePO element1) {
            String type1;
            String name0 = element0.getName() == null ? "" : element0.getName();
            String name1 = element1.getName() == null ? "" : element1.getName();
            String type0 = element0.getComponentType() == null ? "" : element0.getComponentType();
            String string = type1 = element1.getComponentType() == null ? "" : element1.getComponentType();
            if (!type0.equals(type1)) {
                StringHelper helper = StringHelper.getInstance();
                return helper.get(type0, true).compareTo(helper.get(type1, true));
            }
            return name0.toLowerCase().compareTo(name1.toLowerCase());
        }
    }
}

