/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jwt.meta.commands.helper.CommandHelper;
import org.eclipse.jwt.meta.commands.interfaces.IInterruptibleCommand;
import org.eclipse.jwt.meta.model.processes.Activity;
import org.eclipse.jwt.we.PluginProperties;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.util.EMFHelper;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WEDeleteCommand
extends DeleteCommand
implements IInterruptibleCommand {
    private WEEditor weeditor;
    private Set referencedElements = null;

    public WEDeleteCommand(WEEditor weeditor, EditingDomain domain, Collection<?> collection) {
        super(domain, collection);
        this.weeditor = weeditor;
    }

    public boolean checkIfCommandCanBeExecuted() {
        HashSet relevantElements = new HashSet();
        Iterator iterator = this.collection.iterator();
        while (iterator.hasNext()) {
            relevantElements.addAll(EMFHelper.collectRelevantElements((EObject)((EObject)iterator.next())));
        }
        Set referencedElements = EMFHelper.collectReferencedElements(this.weeditor, relevantElements, false);
        HashSet<Activity> activities = new HashSet<Activity>();
        for (Object object : relevantElements) {
            if (!(object instanceof Activity)) continue;
            activities.add((Activity)object);
        }
        for (Object object : referencedElements) {
            if (!(object instanceof Activity)) continue;
            activities.add((Activity)object);
        }
        if (activities.size() > 0 && !this.dialogDeleteActivities(activities)) {
            return false;
        }
        if (referencedElements.size() == 0) {
            return true;
        }
        if (!this.dialogDeleteAllReferences(referencedElements)) {
            return false;
        }
        this.referencedElements = referencedElements;
        return true;
    }

    private boolean dialogDeleteAllReferences(Set referencedElements) {
        String refNameString = "\n\n" + EMFHelper.collectNames((Set)referencedElements) + "\n\n";
        boolean deleteReferences = MessageDialog.openQuestion((Shell)GeneralHelper.getActiveShell(), (String)PluginProperties.editor_StillReferenced_title, (String)NLS.bind((String)PluginProperties.editor_StillReferencedDelete_message, (Object)refNameString));
        if (deleteReferences) {
            deleteReferences = MessageDialog.openQuestion((Shell)GeneralHelper.getActiveShell(), (String)PluginProperties.editor_StillReferenced_title, (String)PluginProperties.editor_StillReferencedConfirmation_message);
        }
        return deleteReferences;
    }

    private boolean dialogDeleteActivities(Set activities) {
        String actNameString = "\n\n" + CommandHelper.collectNames((Set)activities) + "\n\n";
        return MessageDialog.openQuestion(null, (String)PluginProperties.editor_DeleteActivities_title, (String)PluginProperties.bind((String)PluginProperties.editor_DeleteActivities_message, (Object)actNameString));
    }

    public void execute() {
        if (this.referencedElements == null) {
            super.execute();
        } else {
            Set referenceElements = EMFHelper.collectReferencedElements(this.weeditor, this.referencedElements, true);
            Command dC = DeleteCommand.create((EditingDomain)this.domain, (Collection)referenceElements);
            if (dC.canExecute()) {
                this.commandList.add(0, dC);
                this.compoundExecute();
            }
        }
    }

    private void compoundExecute() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            try {
                Command command = (Command)commands.next();
                command.execute();
                continue;
            }
            catch (RuntimeException exception) {
                commands.previous();
                try {
                    while (commands.hasPrevious()) {
                        Command command = (Command)commands.previous();
                        if (command.canUndo()) {
                            command.undo();
                        }
                    }
                }
                catch (RuntimeException nestedException) {
                    CommonPlugin.INSTANCE.log((Object)new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), (Exception)nestedException).fillInStackTrace());
                }
            }
            throw exception;
        }
        LinkedHashSet<EObject> eObjects = new LinkedHashSet<EObject>();
        for (Object wrappedObject : this.collection) {
            TreeIterator j;
            Object object = AdapterFactoryEditingDomain.unwrap(wrappedObject);
            if (object instanceof EObject) {
                eObjects.add((EObject)object);
                j = ((EObject)object).eAllContents();
                while (j.hasNext()) {
                    eObjects.add((EObject)j.next());
                }
                continue;
            }
            if (!(object instanceof Resource)) continue;
            j = ((Resource)object).getAllContents();
            while (j.hasNext()) {
                eObjects.add((EObject)j.next());
            }
        }
        Map usages = EcoreUtil.UsageCrossReferencer.findAll(eObjects, (ResourceSet)this.domain.getResourceSet());
        for (Map.Entry entry : usages.entrySet()) {
            EObject eObject = (EObject)entry.getKey();
            Collection settings = (Collection)entry.getValue();
            for (EStructuralFeature.Setting setting : settings) {
                EStructuralFeature eStructuralFeature;
                EObject referencingEObject = setting.getEObject();
                if (eObjects.contains(referencingEObject) || !(eStructuralFeature = setting.getEStructuralFeature()).isChangeable()) continue;
                if (eStructuralFeature.isMany()) {
                    this.appendAndExecute(RemoveCommand.create((EditingDomain)this.domain, (Object)referencingEObject, (Object)eStructuralFeature, (Object)eObject));
                    continue;
                }
                this.appendAndExecute(SetCommand.create((EditingDomain)this.domain, (Object)referencingEObject, (Object)eStructuralFeature, (Object)SetCommand.UNSET_VALUE));
            }
        }
    }

    public void redo() {
        super.redo();
    }

    public void undo() {
        super.undo();
    }
}

