/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jwt.meta.model.core.ReferenceableElement;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.we.model.view.Diagram;
import org.eclipse.jwt.we.model.view.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveReferenceCommand
extends RemoveCommand {
    private EditingDomain editingDomain;
    private CompoundCommand removeEdgesCommands;
    private Map<Reference, Scope> scopeMap;
    private Map<Reference, ReferenceableElement> refelemMap;
    private Map<Reference, Diagram> diagramMap;

    public RemoveReferenceCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        super(domain, owner, feature, collection);
        this.editingDomain = domain;
    }

    public void doExecute() {
        ArrayList<Reference> newCollection = new ArrayList<Reference>();
        for (Reference reference : this.collection) {
            if (reference.eContainer() == null) continue;
            newCollection.add(reference);
        }
        this.collection = newCollection;
        this.removeEdgesCommands = new CompoundCommand();
        for (Reference reference : this.collection) {
            if (reference.getReferenceEdges().isEmpty()) continue;
            this.removeEdgesCommands.append(DeleteCommand.create((EditingDomain)this.editingDomain, reference.getReferenceEdges()));
        }
        if (this.removeEdgesCommands.canExecute()) {
            this.removeEdgesCommands.execute();
        }
        this.scopeMap = new HashMap<Reference, Scope>();
        this.refelemMap = new HashMap<Reference, ReferenceableElement>();
        this.diagramMap = new HashMap<Reference, Diagram>();
        for (Reference ref : this.collection) {
            if (ref.eContainer() != null) {
                this.diagramMap.put(ref, (Diagram)ref.eContainer());
                ((Diagram)ref.eContainer()).getReferences().remove((Object)ref);
            }
            if (ref.getContainedIn() != null) {
                this.scopeMap.put(ref, ref.getContainedIn());
                ref.setContainedIn(null);
            }
            if (ref.getReference() == null) continue;
            this.refelemMap.put(ref, ref.getReference());
            ref.setReference(null);
        }
    }

    public void doRedo() {
        if (this.removeEdgesCommands.canExecute()) {
            this.removeEdgesCommands.redo();
        }
        for (Reference ref : this.collection) {
            if (ref.eContainer() != null) {
                ((Diagram)ref.eContainer()).getReferences().remove((Object)ref);
            }
            if (ref.getContainedIn() != null) {
                ref.setContainedIn(null);
            }
            if (ref.getReference() == null) continue;
            ref.setReference(null);
        }
    }

    public void doUndo() {
        for (Map.Entry<Reference, Scope> entry : this.scopeMap.entrySet()) {
            entry.getKey().setContainedIn(entry.getValue());
            entry.getKey().setReference(this.refelemMap.get(entry.getKey()));
            this.diagramMap.get(entry.getKey()).getReferences().add((Object)entry.getKey());
        }
        if (!this.removeEdgesCommands.isEmpty()) {
            this.removeEdgesCommands.undo();
        }
    }

    public void doDispose() {
        super.doDispose();
        if (this.removeEdgesCommands != null) {
            this.removeEdgesCommands.dispose();
        }
        this.scopeMap.clear();
        this.refelemMap.clear();
        this.diagramMap.clear();
    }
}

