/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourcesDescriptor;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;

public class DeleteResourcesRefactoringContribution
extends RefactoringContribution {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String ATTRIBUTE_DELETE_CONTENTS = "deleteContents";
    private static final String ATTRIBUTE_NUMBER_OF_RESOURCES = "resources";
    private static final String ATTRIBUTE_ELEMENT = "element";

    @Override
    public Map<String, String> retrieveArgumentMap(RefactoringDescriptor descriptor) {
        if (descriptor instanceof DeleteResourcesDescriptor) {
            DeleteResourcesDescriptor deleteDesc = (DeleteResourcesDescriptor)descriptor;
            HashMap<String, String> map = new HashMap<String, String>();
            IPath[] resources = deleteDesc.getResourcePaths();
            String project = deleteDesc.getProject();
            map.put(ATTRIBUTE_NUMBER_OF_RESOURCES, String.valueOf(resources.length));
            int i = 0;
            while (i < resources.length) {
                map.put(ATTRIBUTE_ELEMENT + (i + 1), ResourceProcessors.resourcePathToHandle(project, resources[i]));
                ++i;
            }
            map.put(ATTRIBUTE_DELETE_CONTENTS, deleteDesc.isDeleteContents() ? TRUE : FALSE);
            return map;
        }
        return Collections.emptyMap();
    }

    @Override
    public RefactoringDescriptor createDescriptor() {
        return new DeleteResourcesDescriptor();
    }

    @Override
    public RefactoringDescriptor createDescriptor(String id, String project, String description, String comment, Map<String, String> arguments, int flags) throws IllegalArgumentException {
        String del = arguments.get(ATTRIBUTE_DELETE_CONTENTS);
        try {
            int numResources = Integer.parseInt(arguments.get(ATTRIBUTE_NUMBER_OF_RESOURCES));
            if (numResources < 0 || numResources > 100000) {
                throw new IllegalArgumentException("Can not restore DeleteResourcesDescriptor from map, number of moved elements invalid");
            }
            IPath[] resourcePaths = new IPath[numResources];
            int i = 0;
            while (i < numResources) {
                String resource = arguments.get(ATTRIBUTE_ELEMENT + String.valueOf(i + 1));
                if (resource == null) {
                    throw new IllegalArgumentException("Can not restore DeleteResourcesDescriptor from map, resource missing");
                }
                resourcePaths[i] = ResourceProcessors.handleToResourcePath(project, resource);
                ++i;
            }
            if (resourcePaths.length > 0) {
                DeleteResourcesDescriptor descriptor = new DeleteResourcesDescriptor();
                descriptor.setProject(project);
                descriptor.setDescription(description);
                descriptor.setComment(comment);
                descriptor.setFlags(flags);
                descriptor.setResourcePaths(resourcePaths);
                descriptor.setDeleteContents(TRUE.equals(del));
                return descriptor;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Can not restore DeleteResourcesDescriptor from map");
        }
        throw new IllegalArgumentException("Can not restore DeleteResourceDescriptor from map");
    }
}

