/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.lang.reflect.Modifier;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.IClassSpecificNameResolver;
import org.eclipse.mat.snapshot.extension.Subject;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.snapshot.model.PrettyPrinter;
import org.eclipse.mat.snapshot.registry.ClassSpecificNameResolverRegistry;

public class CommonNameResolver {

    @Subject(value="java.lang.reflect.AccessibleObject")
    public static class AccessibleObjectResolver
    implements IClassSpecificNameResolver {
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            StringBuilder r = new StringBuilder();
            ISnapshot snapshot = obj.getSnapshot();
            Object val = obj.resolveValue("modifiers");
            if (val instanceof Integer) {
                r.append(Modifier.toString((Integer)val));
                if (r.length() > 0) {
                    r.append(' ');
                }
            }
            if ((ref = (IObject)obj.resolveValue("clazz")) == null) {
                return null;
            }
            this.addClassName(snapshot, ref.getObjectAddress(), r);
            return r.toString();
        }

        protected void addClassName(ISnapshot snapshot, long addr, StringBuilder r) throws SnapshotException {
            int id = snapshot.mapAddressToId(addr);
            IObject ox = snapshot.getObject(id);
            if (ox instanceof IClass) {
                IClass cls = (IClass)ox;
                r.append(cls.getName());
            }
        }
    }

    @Subjects(value={"java.util.concurrent.atomic.AtomicBoolean"})
    public static class AtomicBooleanResolver
    implements IClassSpecificNameResolver {
        public String resolve(IObject heapObject) throws SnapshotException {
            Integer value = (Integer)heapObject.resolveValue("value");
            return value != null ? Boolean.toString(value != 0) : null;
        }
    }

    @Subjects(value={"java.util.concurrent.atomic.AtomicReference"})
    public static class AtomicReferenceValueResolver
    implements IClassSpecificNameResolver {
        public String resolve(IObject heapObject) throws SnapshotException {
            IObject value = (IObject)heapObject.resolveValue("value");
            return value != null ? ClassSpecificNameResolverRegistry.resolve(value) : null;
        }
    }

    @Subjects(value={"java.util.concurrent.atomic.AtomicStampedReference"})
    public static class AtomicStampedReferenceValueResolver
    implements IClassSpecificNameResolver {
        public String resolve(IObject heapObject) throws SnapshotException {
            IObject value = (IObject)heapObject.resolveValue("pair.reference");
            return value != null ? ClassSpecificNameResolverRegistry.resolve(value) : null;
        }
    }

    @Subject(value="byte[]")
    public static class ByteArrayResolver
    implements IClassSpecificNameResolver {
        public String resolve(IObject heapObject) throws SnapshotException {
            IPrimitiveArray arr = (IPrimitiveArray)heapObject;
            byte[] value = (byte[])arr.getValueArray(0, Math.min(arr.getLength(), 1024));
            if (value == null) {
                return null;
            }
            StringBuilder r = new StringBuilder(value.length);
            int i = 0;
            while (i < value.length) {
                if (value[i] < 32 || value[i] > 126) {
                    r.append('.');
                } else {
                    r.append((char)value[i]);
                }
                ++i;
            }
            return r.toString();
        }
    }

    @Subject(value="char[]")
    public static class CharArrayResolver
    implements IClassSpecificNameResolver {
        public String resolve(IObject heapObject) throws SnapshotException {
            IPrimitiveArray charArray = (IPrimitiveArray)heapObject;
            return PrettyPrinter.arrayAsString(charArray, 0, charArray.getLength(), 1024);
        }
    }

    @Subject(value="java.lang.reflect.Constructor")
    public static class ConstructorResolver
    extends AccessibleObjectResolver {
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            StringBuilder r = new StringBuilder();
            ISnapshot snapshot = obj.getSnapshot();
            Object val = obj.resolveValue("modifiers");
            if (val instanceof Integer) {
                r.append(Modifier.toString((Integer)val));
                if (r.length() > 0) {
                    r.append(' ');
                }
            }
            if ((ref = (IObject)obj.resolveValue("clazz")) == null) {
                return null;
            }
            this.addClassName(snapshot, ref.getObjectAddress(), r);
            r.append('(');
            ref = (IObject)obj.resolveValue("parameterTypes");
            if (ref instanceof IObjectArray) {
                IObjectArray orefa = (IObjectArray)ref;
                long[] refs = orefa.getReferenceArray();
                int i = 0;
                while (i < orefa.getLength()) {
                    if (i > 0) {
                        r.append(',');
                    }
                    long addr = refs[i];
                    this.addClassName(snapshot, addr, r);
                    ++i;
                }
            }
            r.append(')');
            return r.toString();
        }
    }

    @Subject(value="java.lang.reflect.Field")
    public static class FieldResolver
    extends AccessibleObjectResolver {
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            StringBuilder r = new StringBuilder();
            ISnapshot snapshot = obj.getSnapshot();
            Object val = obj.resolveValue("modifiers");
            if (val instanceof Integer) {
                r.append(Modifier.toString((Integer)val));
                if (r.length() > 0) {
                    r.append(' ');
                }
            }
            if ((ref = (IObject)obj.resolveValue("type")) != null) {
                this.addClassName(snapshot, ref.getObjectAddress(), r);
                r.append(' ');
            }
            if ((ref = (IObject)obj.resolveValue("clazz")) != null) {
                this.addClassName(snapshot, ref.getObjectAddress(), r);
                r.append('.');
            }
            if ((ref = (IObject)obj.resolveValue("name")) == null) {
                return null;
            }
            r.append(ref.getClassSpecificName());
            return r.toString();
        }
    }

    @Subject(value="java.lang.reflect.Method")
    public static class MethodResolver
    extends AccessibleObjectResolver {
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            StringBuilder r = new StringBuilder();
            ISnapshot snapshot = obj.getSnapshot();
            Object val = obj.resolveValue("modifiers");
            if (val instanceof Integer) {
                r.append(Modifier.toString((Integer)val));
                if (r.length() > 0) {
                    r.append(' ');
                }
            }
            if ((ref = (IObject)obj.resolveValue("returnType")) != null) {
                this.addClassName(snapshot, ref.getObjectAddress(), r);
                r.append(' ');
            }
            if ((ref = (IObject)obj.resolveValue("clazz")) != null) {
                this.addClassName(snapshot, ref.getObjectAddress(), r);
                r.append('.');
            }
            if ((ref = (IObject)obj.resolveValue("name")) == null) {
                return null;
            }
            r.append(ref.getClassSpecificName());
            r.append('(');
            ref = (IObject)obj.resolveValue("parameterTypes");
            if (ref instanceof IObjectArray) {
                IObjectArray orefa = (IObjectArray)ref;
                long[] refs = orefa.getReferenceArray();
                int i = 0;
                while (i < orefa.getLength()) {
                    if (i > 0) {
                        r.append(',');
                    }
                    long addr = refs[i];
                    this.addClassName(snapshot, addr, r);
                    ++i;
                }
            }
            r.append(')');
            return r.toString();
        }
    }

    @Subjects(value={"java.lang.StringBuffer", "java.lang.StringBuilder"})
    public static class StringBufferResolver
    implements IClassSpecificNameResolver {
        public String resolve(IObject obj) throws SnapshotException {
            Integer count = (Integer)obj.resolveValue("count");
            if (count == null) {
                return null;
            }
            if (count == 0) {
                return "";
            }
            IPrimitiveArray charArray = (IPrimitiveArray)obj.resolveValue("value");
            if (charArray == null) {
                return null;
            }
            return PrettyPrinter.arrayAsString(charArray, 0, count, 1024);
        }
    }

    @Subject(value="java.lang.String")
    public static class StringResolver
    implements IClassSpecificNameResolver {
        public String resolve(IObject obj) throws SnapshotException {
            return PrettyPrinter.objectAsString(obj, 1024);
        }
    }

    @Subject(value="java.lang.ThreadGroup")
    public static class ThreadGroupResolver
    implements IClassSpecificNameResolver {
        public String resolve(IObject object) throws SnapshotException {
            IObject nameString = (IObject)object.resolveValue("name");
            if (nameString == null) {
                return null;
            }
            return nameString.getClassSpecificName();
        }
    }

    @Subject(value="java.lang.Thread")
    public static class ThreadResolver
    implements IClassSpecificNameResolver {
        public String resolve(IObject obj) throws SnapshotException {
            IObject name = (IObject)obj.resolveValue("name");
            return name != null ? name.getClassSpecificName() : null;
        }
    }

    @Subject(value="java.net.URL")
    public static class URLResolver
    implements IClassSpecificNameResolver {
        public String resolve(IObject obj) throws SnapshotException {
            IObject ref;
            IObject query;
            IObject path;
            IObject authority;
            StringBuilder builder = new StringBuilder();
            IObject protocol = (IObject)obj.resolveValue("protocol");
            if (protocol != null) {
                builder.append(protocol.getClassSpecificName());
                builder.append(":");
            }
            if ((authority = (IObject)obj.resolveValue("authority")) != null) {
                builder.append("//");
                builder.append(authority.getClassSpecificName());
            }
            if ((path = (IObject)obj.resolveValue("path")) != null) {
                builder.append(path.getClassSpecificName());
            }
            if ((query = (IObject)obj.resolveValue("query")) != null) {
                builder.append("?");
                builder.append(query.getClassSpecificName());
            }
            if ((ref = (IObject)obj.resolveValue("ref")) != null) {
                builder.append("#");
                builder.append(ref.getClassSpecificName());
            }
            return builder.length() > 0 ? builder.toString() : null;
        }
    }

    @Subjects(value={"java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Boolean", "java.util.concurrent.atomic.AtomicInteger", "java.util.concurrent.atomic.AtomicLong"})
    public static class ValueResolver
    implements IClassSpecificNameResolver {
        public String resolve(IObject heapObject) throws SnapshotException {
            Object value = heapObject.resolveValue("value");
            return value != null ? String.valueOf(value) : null;
        }
    }
}

