/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.quantize;

class KeyCalculator {
    KeyCalculator() {
    }

    public Object getKey(Object[] columnValues) {
        return columnValues[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompositeKey
    implements Comparable<CompositeKey> {
        Object[] keys;
        int size;

        public CompositeKey(Object[] columnValues, int noOfGroupedColumns) {
            this.keys = columnValues;
            this.size = noOfGroupedColumns;
        }

        @Override
        public int compareTo(CompositeKey o) {
            if (this.size != o.size) {
                return this.size > o.size ? -1 : 1;
            }
            int ii = 0;
            while (ii < this.size) {
                int c = ((Comparable)this.keys[ii]).compareTo(o.keys[ii]);
                if (c != 0) {
                    return c;
                }
                ++ii;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompositeKey other = (CompositeKey)obj;
            if (this.size != other.size) {
                return false;
            }
            int ii = 0;
            while (ii < this.size) {
                if (!this.keys[ii].equals(other.keys[ii])) {
                    return false;
                }
                ++ii;
            }
            return true;
        }

        public int hashCode() {
            int result = 0;
            int ii = 0;
            while (ii < this.size) {
                result = 31 * result + this.keys[ii].hashCode();
                ++ii;
            }
            return result;
        }
    }

    static class LinearDistributionDouble
    extends KeyCalculator {
        double lowerBound;
        double upperBound;
        double step;

        public LinearDistributionDouble(double lowerBound, double upperBound, double step) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.step = step;
        }

        public Object getKey(Object[] columnValues) {
            double b;
            double v = ((Number)columnValues[0]).doubleValue();
            if (v <= this.lowerBound) {
                return this.lowerBound;
            }
            if (v > this.upperBound) {
                return Double.MAX_VALUE;
            }
            double ret = b = this.upperBound;
            int i = 0;
            while (v <= b) {
                ret = b;
                b = this.upperBound - (double)i * this.step;
                ++i;
            }
            return ret;
        }
    }

    static class LinearDistributionLong
    extends KeyCalculator {
        long lowerBound;
        long upperBound;
        long step;

        public LinearDistributionLong(long lowerBound, long upperBound, long step) {
            this.lowerBound = lowerBound;
            this.upperBound = upperBound;
            this.step = step;
        }

        public Object getKey(Object[] columnValues) {
            long v = ((Number)columnValues[0]).longValue();
            if (v <= this.lowerBound) {
                return this.lowerBound;
            }
            if (v > this.upperBound) {
                return Long.MAX_VALUE;
            }
            return this.lowerBound + this.step * ((v - 1L) / this.step + 1L);
        }
    }

    static class MultipleKeys
    extends KeyCalculator {
        int noOfGroupedColumns;

        public MultipleKeys(int noOfGroupedColumns) {
            this.noOfGroupedColumns = noOfGroupedColumns;
        }

        public Object getKey(Object[] columnValues) {
            return new CompositeKey(columnValues, this.noOfGroupedColumns);
        }
    }
}

