/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer.internal.io.java.binding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.AbstractMethodDeclaration;
import org.eclipse.gmt.modisco.java.AbstractTypeDeclaration;
import org.eclipse.gmt.modisco.java.AnnotationTypeMemberDeclaration;
import org.eclipse.gmt.modisco.java.ArrayType;
import org.eclipse.gmt.modisco.java.ClassDeclaration;
import org.eclipse.gmt.modisco.java.EnumConstantDeclaration;
import org.eclipse.gmt.modisco.java.EnumDeclaration;
import org.eclipse.gmt.modisco.java.FieldDeclaration;
import org.eclipse.gmt.modisco.java.InterfaceDeclaration;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.NamedElement;
import org.eclipse.gmt.modisco.java.Package;
import org.eclipse.gmt.modisco.java.SingleVariableDeclaration;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.gmt.modisco.java.TypeAccess;
import org.eclipse.gmt.modisco.java.TypeDeclaration;
import org.eclipse.gmt.modisco.java.TypeParameter;
import org.eclipse.gmt.modisco.java.UnresolvedItem;
import org.eclipse.gmt.modisco.java.VariableDeclarationFragment;
import org.eclipse.gmt.modisco.java.emf.JavaFactory;
import org.eclipse.gmt.modisco.java.internal.util.JavaUtil;
import org.eclipse.modisco.java.discoverer.internal.JavaActivator;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.Binding;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.ClassBinding;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.FieldBinding;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.MethodBinding;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.PackageBinding;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.ParameterBinding;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.PendingElement;
import org.eclipse.modisco.java.discoverer.internal.io.java.binding.UnresolvedBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingManager {
    private Map<String, NamedElement> targets = new HashMap<String, NamedElement>();
    private final Map<String, UnresolvedItem> unresolvedItems = new HashMap<String, UnresolvedItem>();
    private List<PendingElement> pendings = new ArrayList<PendingElement>();
    private final JavaFactory factory;
    private static final char DOT_SEPARATOR = '.';
    private Model model = null;

    public BindingManager(JavaFactory factory) {
        this.factory = factory;
    }

    public BindingManager(BindingManager aBindingManager) {
        this.factory = aBindingManager.factory;
        this.targets = new HashMap<String, NamedElement>(aBindingManager.targets);
        this.pendings = new ArrayList<PendingElement>(aBindingManager.pendings);
        this.model = aBindingManager.model;
    }

    public void enableIncrementalDiscovering(Model model1) {
        this.model = model1;
    }

    public void disableIncrementalDiscovering() {
        this.model = null;
    }

    public boolean isIncrementalDiscovering() {
        return this.model != null;
    }

    public void addTarget(String binding, NamedElement target) {
        this.targets.put(binding, target);
    }

    public void addTarget(Binding binding, NamedElement target) {
        this.addTarget(binding.toString(), target);
    }

    public boolean containsTarget(String binding) {
        boolean targetFound;
        if (this.targets.containsKey(binding)) {
            targetFound = true;
        } else {
            NamedElement ne = this.searchQNInModel(binding);
            if (ne != null) {
                this.addTarget(binding, ne);
                targetFound = true;
            } else {
                targetFound = false;
            }
        }
        return targetFound;
    }

    public boolean containsTarget(Binding binding) {
        return this.containsTarget(binding.toString());
    }

    public NamedElement getTarget(String id) {
        NamedElement resultNamedElement = null;
        if (id != null) {
            NamedElement ne = this.targets.get(id);
            if (ne != null) {
                resultNamedElement = ne;
            } else {
                ne = this.searchQNInModel(id);
                if (ne != null) {
                    this.addTarget(id, ne);
                    resultNamedElement = ne;
                }
            }
        }
        return resultNamedElement;
    }

    public NamedElement getTarget(Binding binding) {
        NamedElement target = null;
        if (!(binding instanceof UnresolvedBinding)) {
            target = this.getTarget(binding.toString());
        }
        return target;
    }

    public void addPending(PendingElement ref, Binding binding) {
        ref.setBinding(binding);
        this.pendings.add(ref);
    }

    public PendingElement getPending(ASTNode clientNode, String linkName) {
        PendingElement result = null;
        for (PendingElement pe : this.pendings) {
            if (pe.getClientNode() == null || !pe.getClientNode().equals(clientNode) || pe.getLinkName() == null || !pe.getLinkName().equals(linkName)) continue;
            result = pe;
        }
        return result;
    }

    public void resolveBindings(Model model1) {
        ArrayList<PendingElement> unresolvedBindings = new ArrayList<PendingElement>();
        for (PendingElement pe : this.pendings) {
            if (pe.getClientNode() == null) continue;
            NamedElement target = this.getTarget(pe.getBinding());
            if (target == null) {
                unresolvedBindings.add(pe);
                continue;
            }
            pe.affectTarget((ASTNode)target);
        }
        this.manageUnresolvedBindings(model1, unresolvedBindings);
    }

    private void manageUnresolvedBindings(Model model1, List<PendingElement> unresolvedBindings) {
        if (model1 != null) {
            for (PendingElement pe : unresolvedBindings) {
                NamedElement target = null;
                target = this.getProxyElement(pe, model1);
                if (target == null) continue;
                pe.affectTarget((ASTNode)target);
            }
        }
    }

    private NamedElement searchQNInModel(String qualifiedName) {
        NamedElement resultNamedElement = null;
        if (this.isIncrementalDiscovering() && (resultNamedElement = JavaUtil.getNamedElementByQualifiedName((Model)this.model, (String)qualifiedName, this.targets)) != null) {
            this.addTarget(qualifiedName, resultNamedElement);
        }
        return resultNamedElement;
    }

    public void resolveBindings() {
        this.resolveBindings(null);
    }

    private NamedElement getProxyElement(PendingElement pe, Model model1) {
        Object result = null;
        Binding bd = pe.getBinding();
        if (bd instanceof PackageBinding) {
            result = this.getPackageDeclaration((PackageBinding)bd, model1);
        } else if (bd instanceof ClassBinding) {
            result = this.getTypeDeclaration((ClassBinding)bd, model1);
        } else if (bd instanceof FieldBinding) {
            result = ((FieldBinding)bd).isEnumConstant() ? this.getEnumConstantDeclaration((FieldBinding)bd, model1) : this.getFieldDeclaration((FieldBinding)bd, model1);
        } else if (bd instanceof MethodBinding) {
            result = ((MethodBinding)bd).isAnnotationMember() ? this.getAnnotationTypeMemberDeclaration((MethodBinding)bd, model1) : this.getMethodDeclaration((MethodBinding)bd, model1);
        } else {
            EStructuralFeature feature;
            result = (NamedElement)this.unresolvedItems.get(bd.getName());
            if (result != null && !(feature = pe.getClientNode().eClass().getEStructuralFeature(pe.getLinkName())).getEType().isInstance(result)) {
                result = null;
            }
            if (result == null) {
                result = pe.affectUnresolvedTarget();
                result.setName(bd.getName());
                result.setProxy(true);
                model1.getUnresolvedItems().add((Object)((UnresolvedItem)result));
                this.unresolvedItems.put(bd.getName(), (UnresolvedItem)result);
            }
        }
        return result;
    }

    private Package getPackageDeclaration(PackageBinding binding, Model model1) {
        Package result = (Package)this.getTarget(binding);
        if (result == null) {
            result = this.createProxiesPackageHierarchy(binding, model1);
            this.addTarget(binding, (NamedElement)result);
        }
        return result;
    }

    private NamedElement getTypeDeclaration(ClassBinding binding, Model model1) {
        Object result = this.getTarget(binding);
        if (result == null) {
            ClassDeclaration superClass;
            Status status;
            result = binding.isAnnotation() ? this.factory.createAnnotationTypeDeclaration() : (binding.isEnum() ? this.factory.createEnumDeclaration() : (binding.isInterface() ? this.factory.createInterfaceDeclaration() : this.factory.createClassDeclaration()));
            result.setName(binding.getName());
            result.setProxy(true);
            if (binding.getOwnerPackage() != null && binding.getDeclaringClass() == null) {
                Package owner = this.getPackageDeclaration(binding.getOwnerPackage(), model1);
                if (owner != null) {
                    if (result instanceof AbstractTypeDeclaration) {
                        ((AbstractTypeDeclaration)result).setPackage(owner);
                    }
                    owner.getOwnedElements().add((Object)((AbstractTypeDeclaration)result));
                } else {
                    status = new Status(4, "org.eclipse.modisco.java.discoverer", "Unkown error.", (Throwable)new Exception("owner == null: " + binding.getOwnerPackage().getName()));
                    JavaActivator.getDefault().getLog().log((IStatus)status);
                }
            } else if (binding.getDeclaringClass() != null) {
                AbstractTypeDeclaration declaring = (AbstractTypeDeclaration)this.getTypeDeclaration(binding.getDeclaringClass(), model1);
                if (declaring != null) {
                    declaring.getBodyDeclarations().add((Object)((AbstractTypeDeclaration)result));
                }
            } else if (result instanceof Type) {
                model1.getOrphanTypes().add((Object)((Type)result));
            } else {
                String message = String.valueOf(binding.toString()) + " will not be contained by the model element.";
                status = new Status(4, "org.eclipse.modisco.java.discoverer", message);
                JavaActivator.getDefault().getLog().log((IStatus)status);
            }
            if (!binding.isInterface() && binding.getSuperClass() != null && (superClass = (ClassDeclaration)this.getTypeDeclaration(binding.getSuperClass(), model1)) != null) {
                TypeAccess typAcc = this.factory.createTypeAccess();
                typAcc.setType((Type)superClass);
                ((ClassDeclaration)result).setSuperClass(typAcc);
            }
            if (binding.getSuperInterfaces() != null) {
                for (ClassBinding anInterface : binding.getSuperInterfaces()) {
                    InterfaceDeclaration superInterface = (InterfaceDeclaration)this.getTypeDeclaration(anInterface, model1);
                    if (superInterface == null) continue;
                    TypeAccess typAcc = this.factory.createTypeAccess();
                    typAcc.setType((Type)superInterface);
                    ((AbstractTypeDeclaration)result).getSuperInterfaces().add((Object)typAcc);
                }
            }
            if (binding.getTypeParameters() != null) {
                for (String typeParameterName : binding.getTypeParameters()) {
                    TypeParameter typeParameter = this.factory.createTypeParameter();
                    typeParameter.setName(typeParameterName);
                    typeParameter.setProxy(true);
                    ((TypeDeclaration)result).getTypeParameters().add((Object)typeParameter);
                }
            }
            this.addTarget(binding, (NamedElement)result);
        }
        return result;
    }

    private EnumConstantDeclaration getEnumConstantDeclaration(FieldBinding binding, Model model1) {
        EnumConstantDeclaration result = (EnumConstantDeclaration)this.getTarget(binding);
        if (result == null) {
            result = this.factory.createEnumConstantDeclaration();
            result.setProxy(true);
            result.setName(binding.getName());
            if (binding.getDeclaringClass() != null) {
                EnumDeclaration declaring = (EnumDeclaration)this.getTypeDeclaration(binding.getDeclaringClass(), model1);
                if (declaring != null) {
                    declaring.getEnumConstants().add((Object)result);
                }
            } else {
                model1.eResource().getContents().add((Object)result);
            }
            this.addTarget(binding, (NamedElement)result);
        }
        return result;
    }

    private VariableDeclarationFragment getFieldDeclaration(FieldBinding binding, Model model1) {
        VariableDeclarationFragment result = (VariableDeclarationFragment)this.getTarget(binding);
        if (result == null) {
            FieldDeclaration field = this.factory.createFieldDeclaration();
            field.setProxy(true);
            result = this.factory.createVariableDeclarationFragment();
            result.setProxy(true);
            result.setName(binding.getName());
            field.getFragments().add((Object)result);
            if (binding.getDeclaringClass() != null) {
                AbstractTypeDeclaration declaring = (AbstractTypeDeclaration)this.getTypeDeclaration(binding.getDeclaringClass(), model1);
                if (declaring != null) {
                    declaring.getBodyDeclarations().add((Object)field);
                }
            } else {
                model1.eResource().getContents().add((Object)field);
            }
            this.addTarget(binding, (NamedElement)result);
        }
        return result;
    }

    private AbstractMethodDeclaration getMethodDeclaration(MethodBinding binding, Model model1) {
        Object result = (AbstractMethodDeclaration)this.getTarget(binding);
        if (result == null) {
            AbstractTypeDeclaration declaring;
            result = binding.isConstructor() ? this.factory.createConstructorDeclaration() : this.factory.createMethodDeclaration();
            result.setProxy(true);
            result.setName(binding.getName());
            int i = 0;
            while (i < binding.getParameters().size()) {
                ParameterBinding param = binding.getParameters().get(i);
                SingleVariableDeclaration paramDecl = this.factory.createSingleVariableDeclaration();
                paramDecl.setProxy(true);
                paramDecl.setName("arg" + i);
                result.getParameters().add((Object)paramDecl);
                TypeAccess typAcc = this.factory.createTypeAccess();
                if (param.isArray()) {
                    typAcc.setType((Type)this.getArrayTypeDeclaration(param, model1));
                } else {
                    typAcc.setType((Type)this.getTypeDeclaration(param.getElementType(), model1));
                }
                paramDecl.setType(typAcc);
                ++i;
            }
            if (binding.getDeclaringClass() != null && (declaring = (AbstractTypeDeclaration)this.getTypeDeclaration(binding.getDeclaringClass(), model1)) != null) {
                declaring.getBodyDeclarations().add(result);
            }
            this.addTarget(binding, (NamedElement)result);
        }
        return result;
    }

    private ArrayType getArrayTypeDeclaration(ParameterBinding binding, Model model1) {
        ArrayType result = (ArrayType)this.getTarget(binding);
        if (result == null) {
            result = this.factory.createArrayType();
            result.setName(binding.toString());
            result.setDimensions(binding.getDimensions());
            TypeAccess typAcc = this.factory.createTypeAccess();
            typAcc.setType((Type)this.getTypeDeclaration(binding.getElementType(), model1));
            result.setElementType(typAcc);
            model1.getOrphanTypes().add((Object)result);
            this.addTarget(binding, (NamedElement)result);
        }
        return result;
    }

    private AnnotationTypeMemberDeclaration getAnnotationTypeMemberDeclaration(MethodBinding binding, Model model1) {
        AnnotationTypeMemberDeclaration result = (AnnotationTypeMemberDeclaration)this.getTarget(binding);
        if (result == null) {
            AbstractTypeDeclaration declaring;
            result = this.factory.createAnnotationTypeMemberDeclaration();
            result.setProxy(true);
            result.setName(binding.getName());
            if (binding.getDeclaringClass() != null && (declaring = (AbstractTypeDeclaration)this.getTypeDeclaration(binding.getDeclaringClass(), model1)) != null) {
                declaring.getBodyDeclarations().add((Object)result);
            }
            this.addTarget(binding, (NamedElement)result);
        }
        return result;
    }

    private Package createProxiesPackageHierarchy(PackageBinding binding, Model model1) {
        Package result = this.factory.createPackage();
        result.setProxy(true);
        if (binding.getName().indexOf(46) == -1) {
            result.setName(binding.getName());
            model1.getOwnedElements().add((Object)result);
        } else {
            String currentPackageName = binding.getName();
            Package currentPackage = result;
            int lastDotIndex = currentPackageName.lastIndexOf(46);
            currentPackage.setName(currentPackageName.substring(lastDotIndex + 1));
            while (lastDotIndex > 0) {
                currentPackageName = currentPackageName.substring(0, lastDotIndex);
                Package aParentPackage = null;
                if (!this.containsTarget(currentPackageName)) {
                    aParentPackage = this.factory.createPackage();
                    aParentPackage.setProxy(true);
                    this.addTarget(currentPackageName, (NamedElement)aParentPackage);
                    lastDotIndex = currentPackageName.lastIndexOf(46);
                    if (lastDotIndex < 0) {
                        aParentPackage.setName(currentPackageName);
                        model1.getOwnedElements().add((Object)aParentPackage);
                    } else {
                        aParentPackage.setName(currentPackageName.substring(lastDotIndex + 1));
                    }
                } else {
                    aParentPackage = (Package)this.getTarget(currentPackageName);
                    aParentPackage.getOwnedPackages().add((Object)currentPackage);
                    break;
                }
                aParentPackage.getOwnedPackages().add((Object)currentPackage);
                currentPackage = aParentPackage;
            }
        }
        return result;
    }
}

