/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.builds.core.BuildState;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildElement;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.internal.core.operations.AbortBuildOperation;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeEvent;
import org.eclipse.mylyn.builds.internal.core.operations.OperationChangeListener;
import org.eclipse.mylyn.internal.builds.ui.BuildImages;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class AbortBuildAction
extends BaseSelectionListenerAction {
    public AbortBuildAction() {
        super("Abort Build");
        this.setToolTipText("Abort Build");
        this.setImageDescriptor(BuildImages.ABORT);
        this.setDisabledImageDescriptor(BuildImages.ABORT_DISABLED);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object element = selection.getFirstElement();
        if (element instanceof IBuild) {
            IBuild build = (IBuild)element;
            return build.getState() == BuildState.RUNNING;
        }
        if (element instanceof IBuildPlan) {
            IBuildPlan buildPlan = (IBuildPlan)element;
            return buildPlan.getState() == BuildState.RUNNING;
        }
        return false;
    }

    public void run() {
        Object selection = this.getStructuredSelection().getFirstElement();
        if (selection instanceof IBuild) {
            IBuild build = (IBuild)selection;
            AbortBuildAction.abortBuild(build);
        } else if (selection instanceof IBuildPlan) {
            IBuildPlan buildPlan = (IBuildPlan)selection;
            AbortBuildAction.abortBuild(buildPlan.getLastBuild());
        }
    }

    public static void abortBuild(final IBuild build) {
        AbortBuildOperation operation = BuildsUiInternal.getFactory().getAbortBuildOperation(build);
        operation.addOperationChangeListener(new OperationChangeListener(){

            public void done(OperationChangeEvent event) {
                if (event.getStatus().isOK()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            BuildsUiInternal.getFactory().getRefreshOperation((IBuildElement)build.getPlan()).execute();
                        }
                    });
                }
            }
        });
        operation.execute();
    }
}

