/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.editor;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.editor.Activator;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;

public class PapyrusNavigationLocation
extends NavigationLocation {
    private URI pageURI;

    public PapyrusNavigationLocation(IEditorPart editorPart) {
        super(editorPart);
        PageRef pageRef;
        PapyrusMultiDiagramEditor papyrusEditor;
        IPage selectedPage;
        if (editorPart instanceof PapyrusMultiDiagramEditor && (selectedPage = (papyrusEditor = (PapyrusMultiDiagramEditor)editorPart).getISashWindowsContainer().getActiveSashWindowsPage()) != null && selectedPage.getRawModel() instanceof PageRef && (pageRef = (PageRef)selectedPage.getRawModel()) != null && pageRef.getEmfPageIdentifier() != null) {
            this.pageURI = EcoreUtil.getURI((EObject)pageRef.getEmfPageIdentifier());
        }
    }

    public void restoreLocation() {
        block6: {
            IEditorPart editorPart = this.getEditorPart();
            if (editorPart instanceof PapyrusMultiDiagramEditor) {
                try {
                    EObject context;
                    IPageManager pageManager = ServiceUtils.getInstance().getIPageManager((Object)((PapyrusMultiDiagramEditor)editorPart).getServicesRegistry());
                    EObject objectToOpen = ServiceUtils.getInstance().getModelSet((Object)((PapyrusMultiDiagramEditor)editorPart).getServicesRegistry()).getEObject(this.pageURI, false);
                    if (objectToOpen == null || (context = EMFHelper.getEObject((Object)objectToOpen)) == null) break block6;
                    try {
                        pageManager = ServiceUtilsForEObject.getInstance().getIPageManager((Object)context);
                        if (pageManager.isOpen((Object)objectToOpen)) {
                            pageManager.selectPage((Object)objectToOpen);
                            break block6;
                        }
                        pageManager.openPage((Object)objectToOpen);
                    }
                    catch (Exception ex) {
                        Activator.log.error((Throwable)ex);
                    }
                }
                catch (ServiceException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        if (currentLocation instanceof PapyrusNavigationLocation && ((PapyrusNavigationLocation)currentLocation).getPageURI() != null && this.pageURI != null) {
            return ((PapyrusNavigationLocation)currentLocation).getPageURI().equals(this.pageURI);
        }
        return false;
    }

    public URI getPageURI() {
        return this.pageURI;
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }

    public void update() {
    }
}

