/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.extensionpoints.editors.ui;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.extensionpoints.editors.definition.IDirectEditorExtensionPoint;
import org.eclipse.papyrus.extensionpoints.editors.ui.GMFEmbeddedEditorActionDelegate;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectEditorsContributionItem
extends ContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;
    private MenuItem subMenuItem;

    public DirectEditorsContributionItem() {
        this.setId("org.eclipse.papyrus.editors.menuitem");
    }

    public DirectEditorsContributionItem(String id) {
        super(id);
    }

    public void dispose() {
        if (this.subMenuItem != null && !this.subMenuItem.isDisposed()) {
            this.subMenuItem.dispose();
        }
    }

    public void fill(Composite parent) {
    }

    public void fill(Menu menu, int index) {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement == null) {
            return;
        }
        EObject businessObject = EMFHelper.getEObject((Object)selectedElement);
        if (businessObject == null) {
            return;
        }
        Collection<IDirectEditorExtensionPoint> configurations = DirectEditorsUtil.getDirectEditorConfigurations(businessObject, selectedElement);
        if (configurations.isEmpty()) {
            return;
        }
        this.createSubMenu(menu, index, selectedElement, businessObject, configurations);
    }

    protected void createSubMenu(Menu menu, int index, Object selectedElement, EObject businessObject, Collection<IDirectEditorExtensionPoint> configurations) {
        this.subMenuItem = new MenuItem(menu, 64);
        String type = businessObject instanceof EObject ? businessObject.eClass().getName() : "";
        this.subMenuItem.setText("Edit " + type);
        Menu subMenu = new Menu(menu);
        this.subMenuItem.setMenu(subMenu);
        IDirectEditorExtensionPoint defaultConfig = DirectEditorsUtil.getDefautDirectEditorConfiguration(businessObject, selectedElement);
        for (final IDirectEditorExtensionPoint configuration : configurations) {
            MenuItem item = new MenuItem(subMenu, 0);
            StringBuffer buffer = new StringBuffer();
            buffer.append("Using ");
            buffer.append(configuration.getLanguage());
            if (configuration.equals(defaultConfig)) {
                buffer.append(" (Default via F2)");
            }
            item.setText(buffer.toString());
            item.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    GMFEmbeddedEditorActionDelegate actionDelegate = new GMFEmbeddedEditorActionDelegate();
                    actionDelegate.setActivePart(null, (IWorkbenchPart)((IMultiDiagramEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()).getActiveEditor());
                    actionDelegate.selectionChanged(null, DirectEditorsContributionItem.this.getSelection());
                    actionDelegate.setExtensionPointConfiguration(configuration);
                    actionDelegate.run(null);
                }
            });
        }
    }

    protected Object getSelectedElement() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).getFirstElement();
        }
        return null;
    }

    protected ISelection getSelection() {
        ISelectionService selectionService = this.getSelectionService();
        if (selectionService != null) {
            return selectionService.getSelection();
        }
        return null;
    }

    protected ISelectionService getSelectionService() {
        ISelectionService selectionService = (ISelectionService)this.serviceLocator.getService(ISelectionService.class);
        return selectionService;
    }

    public void fill(ToolBar parent, int index) {
    }

    public void fill(CoolBar parent, int index) {
    }

    public void saveWidgetState() {
    }

    public boolean isDirty() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isDynamic() {
        return true;
    }

    public boolean isGroupMarker() {
        return false;
    }

    public boolean isSeparator() {
        return false;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getName()) + "(id=" + this.getId() + ")";
    }

    public void update() {
    }

    public void update(String id) {
    }

    public void initialize(IServiceLocator serviceLocator) {
        assert (serviceLocator != null);
        this.serviceLocator = serviceLocator;
    }
}

