/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.celleditor.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class CellAxisConfigurationRegistry {
    private List<ICellAxisConfiguration> registry;
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.nattable.celleditor.configuration";
    public static final String CELL_EDITOR_CONFIGURATION_CLASS_ATTRIBUTE = "class";
    public static final String ORDER_ATTRIBUTE = "order";
    public static final CellAxisConfigurationRegistry INSTANCE = new CellAxisConfigurationRegistry();
    public static final String CONFIGURATION_EXT_NEW = "cellAxisConfiguration";

    private CellAxisConfigurationRegistry() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        this.registry = new ArrayList<ICellAxisConfiguration>(configElements.length);
        final HashMap<ICellAxisConfiguration, Integer> ordering = new HashMap<ICellAxisConfiguration, Integer>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
            if (CONFIGURATION_EXT_NEW.equals(iConfigurationElement.getName())) {
                Integer order = new Integer(iConfigurationElement.getAttribute(ORDER_ATTRIBUTE));
                try {
                    ICellAxisConfiguration factory = (ICellAxisConfiguration)iConfigurationElement.createExecutableExtension(CELL_EDITOR_CONFIGURATION_CLASS_ATTRIBUTE);
                    if (factory != null) {
                        ordering.put(factory, order);
                        this.registry.add(factory);
                    }
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
            }
            ++n2;
        }
        Collections.sort(this.registry, new Comparator<ICellAxisConfiguration>(){

            @Override
            public int compare(ICellAxisConfiguration o1, ICellAxisConfiguration o2) {
                return (Integer)ordering.get(o1) - (Integer)ordering.get(o2);
            }
        });
    }

    public ICellAxisConfiguration getCellEditorConfiguration(String configurationId) {
        Assert.isNotNull((Object)configurationId);
        for (ICellAxisConfiguration current : this.registry) {
            if (!configurationId.equals(current.getConfigurationId())) continue;
            return current;
        }
        return null;
    }

    public ICellAxisConfiguration getFirstCellEditorConfiguration(Table table, Object obj) {
        List<ICellAxisConfiguration> configurations = this.getCellEditorConfigurationFactories(table, obj);
        if (!configurations.isEmpty()) {
            return configurations.get(0);
        }
        return null;
    }

    public ICellAxisConfiguration getFirstCellEditorConfiguration(INattableModelManager tableManager, Object obj) {
        return this.getFirstCellEditorConfiguration(tableManager.getTable(), obj);
    }

    public List<ICellAxisConfiguration> getCellEditorConfigurationFactories(Table table, Object obj) {
        ArrayList<ICellAxisConfiguration> factories = new ArrayList<ICellAxisConfiguration>();
        for (ICellAxisConfiguration current : this.registry) {
            if (!current.handles(table, obj)) continue;
            factories.add(current);
        }
        return factories;
    }
}

