/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.StringToNumberConverter;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.editors.StringEditor;
import org.eclipse.papyrus.infra.widgets.validator.UnlimitedNaturalValidator;
import org.eclipse.swt.widgets.Composite;

public class UnlimitedNaturalEditor
extends StringEditor {
    private IConverter targetToModelConverter;

    public UnlimitedNaturalEditor(Composite parent, int style) {
        this(parent, style, null);
    }

    public UnlimitedNaturalEditor(Composite parent, int style, String label) {
        super(parent, style, label);
        this.targetValidator = new UnlimitedNaturalValidator();
        this.targetToModelConverter = new IConverter(){

            public Object getToType() {
                return Integer.class;
            }

            public Object getFromType() {
                return String.class;
            }

            public Integer convert(Object fromObject) {
                if (fromObject instanceof String) {
                    String newString = ((String)fromObject).replaceAll(" ", "");
                    if (newString.equals("*")) {
                        return -1;
                    }
                    return (Integer)StringToNumberConverter.toInteger((boolean)false).convert((Object)newString);
                }
                return 0;
            }
        };
        IConverter integerToString = new IConverter(){

            public Object getToType() {
                return String.class;
            }

            public Object getFromType() {
                return Integer.class;
            }

            public Object convert(Object fromObject) {
                if (fromObject instanceof Integer) {
                    if ((Integer)fromObject == -1) {
                        return "*";
                    }
                    return Integer.toString((Integer)fromObject);
                }
                return "";
            }
        };
        this.setValidateOnDelay(true);
        this.setConverters(this.targetToModelConverter, integerToString);
        this.setTargetAfterGetValidator(this.targetValidator);
    }

    @Override
    public Object getEditableType() {
        return Integer.class;
    }

    @Override
    public Integer getValue() {
        try {
            return (Integer)this.targetToModelConverter.convert(super.getValue());
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            return null;
        }
    }
}

