/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.GenericSourcePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;

public abstract class MultiSourceEditor
extends PDEFormEditor {
    protected void addSourcePage(String contextId) {
        InputContext context = this.fInputContextManager.findContext(contextId);
        if (context == null) {
            return;
        }
        if (this.findPage(contextId) != null) {
            return;
        }
        PDESourcePage sourcePage = this.createSourcePage(this, contextId, context.getInput().getName(), context.getId());
        sourcePage.setInputContext(context);
        try {
            this.addPage((IEditorPart)sourcePage, context.getInput());
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    protected void removePage(String pageId) {
        IFormPage page = this.findPage(pageId);
        if (page == null) {
            return;
        }
        if (!page.isDirty()) {
            this.removePage(page.getIndex());
            if (!page.isEditor()) {
                page.dispose();
            }
        }
    }

    protected PDESourcePage createSourcePage(PDEFormEditor editor, String title, String name, String contextId) {
        return new GenericSourcePage(editor, title, name);
    }
}

