/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.ast.nodes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.match.ASTMatcher;
import org.eclipse.php.core.ast.nodes.AST;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ChildPropertyDescriptor;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.Statement;
import org.eclipse.php.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.core.ast.visitor.Visitor;

public class GotoStatement
extends Statement {
    private Identifier label;
    public static final ChildPropertyDescriptor LABEL_PROPERTY = new ChildPropertyDescriptor(GotoStatement.class, "label", Identifier.class, true, true);
    private static final List<StructuralPropertyDescriptor> PROPERTY_DESCRIPTORS;

    static {
        ArrayList<ChildPropertyDescriptor> propertyList = new ArrayList<ChildPropertyDescriptor>(1);
        propertyList.add(LABEL_PROPERTY);
        PROPERTY_DESCRIPTORS = Collections.unmodifiableList(propertyList);
    }

    public GotoStatement(int start, int end, AST ast, Identifier label) {
        super(start, end, ast);
        if (label == null) {
            throw new IllegalArgumentException();
        }
        this.setLabel(label);
    }

    public GotoStatement(AST ast) {
        super(ast);
    }

    @Override
    public void accept0(Visitor visitor) {
        boolean visit = visitor.visit(this);
        if (visit) {
            this.childrenAccept(visitor);
        }
        visitor.endVisit(this);
    }

    @Override
    public void childrenAccept(Visitor visitor) {
        this.label.accept(visitor);
    }

    @Override
    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.label.traverseTopDown(visitor);
    }

    @Override
    public void traverseBottomUp(Visitor visitor) {
        this.label.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    @Override
    public void toString(StringBuffer buffer, String tab) {
        buffer.append(tab).append("<GotoStatement");
        this.appendInterval(buffer);
        buffer.append(">\n");
        this.label.toString(buffer, "\t" + tab);
        buffer.append("\n").append(tab).append("</GotoStatement>");
    }

    @Override
    public int getType() {
        return 69;
    }

    public Identifier getLabel() {
        return this.label;
    }

    public void setLabel(Identifier label) {
        if (label == null) {
            throw new IllegalArgumentException();
        }
        Identifier oldChild = this.label;
        this.preReplaceChild(oldChild, label, LABEL_PROPERTY);
        this.label = label;
        this.postReplaceChild(oldChild, label, LABEL_PROPERTY);
    }

    @Override
    final ASTNode internalGetSetChildProperty(ChildPropertyDescriptor property, boolean get, ASTNode child) {
        if (property == LABEL_PROPERTY) {
            if (get) {
                return this.getLabel();
            }
            this.setLabel((Identifier)child);
            return null;
        }
        return super.internalGetSetChildProperty(property, get, child);
    }

    @Override
    public boolean subtreeMatch(ASTMatcher matcher, Object other) {
        return matcher.match(this, other);
    }

    @Override
    ASTNode clone0(AST target) {
        Identifier label = ASTNode.copySubtree(target, this.getLabel());
        GotoStatement result = new GotoStatement(this.getStart(), this.getEnd(), target, label);
        return result;
    }

    @Override
    List<StructuralPropertyDescriptor> internalStructuralPropertiesForType(PHPVersion apiLevel) {
        return PROPERTY_DESCRIPTORS;
    }
}

