/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.phps;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.debug.ui.preferences.phps.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class PHPsSearchResultDialog
extends MessageDialog {
    private List<PHPexeItem> results;
    private CheckboxTableViewer resultTableViewer;
    private ArrayList<PHPexeItem> phpExecs = new ArrayList();

    protected PHPsSearchResultDialog(List<PHPexeItem> results, String message) {
        super(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.PHPsSearchResultDialog_PHP_executables_search, null, message, 2, new String[]{Messages.PHPsSearchResultDialog_Add, Messages.PHPsSearchResultDialog_Cancel}, 0);
        this.results = results;
    }

    protected Control createCustomArea(Composite parent) {
        return this.createResultTable(parent);
    }

    private Control createResultTable(Composite composite) {
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        compositeLayout.numColumns = 2;
        composite.setLayout((Layout)compositeLayout);
        Composite tableComposite = new Composite(composite, 0);
        GridLayout tableCompositeLayout = new GridLayout();
        tableCompositeLayout.marginHeight = 0;
        tableCompositeLayout.marginWidth = 0;
        tableComposite.setLayout((Layout)tableCompositeLayout);
        GridData tcGridData = new GridData(4, 4, true, true);
        tcGridData.widthHint = 560;
        tableComposite.setLayoutData((Object)tcGridData);
        Composite buttonsComposite = new Composite(composite, 0);
        GridLayout buttonsCompositeLayout = new GridLayout();
        buttonsCompositeLayout.marginHeight = 0;
        buttonsCompositeLayout.marginWidth = 0;
        buttonsComposite.setLayout((Layout)buttonsCompositeLayout);
        buttonsComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        GridData tableCompositeGridData = new GridData(4, 4, true, true);
        Table resultTable = new Table(tableComposite, 68388);
        resultTable.setLayoutData((Object)tableCompositeGridData);
        resultTable.setHeaderVisible(true);
        resultTable.setLinesVisible(true);
        this.resultTableViewer = new CheckboxTableViewer(resultTable);
        this.resultTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.resultTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableColumn nameColumn = new TableColumn(resultTable, 16384);
        nameColumn.setText(Messages.PHPsSearchResultDialog_Name);
        TableColumn debuggerColumn = new TableColumn(resultTable, 16384);
        debuggerColumn.setText(Messages.PHPsSearchResultDialog_Debugger_column);
        TableColumn versionColumn = new TableColumn(resultTable, 16384);
        versionColumn.setText(Messages.PHPsSearchResultDialog_Version_column);
        TableColumn locationColumn = new TableColumn(resultTable, 16384);
        locationColumn.setText(Messages.PHPsSearchResultDialog_Location);
        TableColumnLayout clayout = new TableColumnLayout();
        PixelConverter pixelConverter = new PixelConverter(composite.getFont());
        clayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(25, pixelConverter.convertWidthInCharsToPixels(25)));
        clayout.setColumnData((Widget)debuggerColumn, (ColumnLayoutData)new ColumnWeightData(20, pixelConverter.convertWidthInCharsToPixels(12)));
        clayout.setColumnData((Widget)versionColumn, (ColumnLayoutData)new ColumnWeightData(10, pixelConverter.convertWidthInCharsToPixels(8)));
        clayout.setColumnData((Widget)locationColumn, (ColumnLayoutData)new ColumnWeightData(25, pixelConverter.convertWidthInCharsToPixels(35)));
        resultTable.getParent().setLayout((Layout)clayout);
        this.resultTableViewer.setInput(this.results);
        this.resultTableViewer.setAllChecked(true);
        Button selectAll = new Button(buttonsComposite, 8);
        selectAll.setText(Messages.PHPsSearchResultDialog_Select_all);
        selectAll.setLayoutData((Object)new GridData(4, 4, true, false));
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPsSearchResultDialog.this.resultTableViewer.setAllChecked(true);
            }
        });
        Button deselectAll = new Button(buttonsComposite, 8);
        deselectAll.setText(Messages.PHPsSearchResultDialog_Deselect_all);
        deselectAll.setLayoutData((Object)new GridData(4, 4, true, false));
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPsSearchResultDialog.this.resultTableViewer.setAllChecked(false);
            }
        });
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            Object[] selected;
            Object[] objectArray = selected = this.resultTableViewer.getCheckedElements();
            int n = selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object s = objectArray[n2];
                PHPexeItem phpExe = (PHPexeItem)s;
                if (phpExe.getDebuggerID() == null) {
                    phpExe.setDebuggerID(PHPDebuggersRegistry.getDefaultDebuggerId());
                }
                this.phpExecs.add(phpExe);
                ++n2;
            }
        }
        super.buttonPressed(buttonId);
    }

    public List<PHPexeItem> getPHPExecutables() {
        return this.phpExecs;
    }

    protected boolean isResizable() {
        return true;
    }

    private class LabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return PHPDebugUIImages.get("IMG_OBJ_PHP_EXE");
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((PHPexeItem)element).getName();
                }
                case 1: {
                    String debugger = PHPDebuggersRegistry.getDebuggerName((String)((PHPexeItem)element).getDebuggerID());
                    return debugger != null ? debugger : "<none>";
                }
                case 2: {
                    return ((PHPexeItem)element).getVersion();
                }
                case 3: {
                    return ((PHPexeItem)element).getExecutable().getAbsolutePath();
                }
            }
            return null;
        }
    }
}

