/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.ScriptElementImageDescriptor;
import org.eclipse.dltk.ui.ScriptElementImageProvider;
import org.eclipse.dltk.ui.text.completion.AbstractScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.FieldProposalInfo;
import org.eclipse.dltk.ui.text.completion.ICompletionProposalInfo;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.MethodProposalInfo;
import org.eclipse.dltk.ui.text.completion.ProposalInfo;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposalCollector;
import org.eclipse.dltk.ui.text.completion.TypeProposalInfo;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.core.project.ProjectOptions;
import org.eclipse.php.internal.core.codeassist.AliasField;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.codeassist.IPHPCompletionRequestor;
import org.eclipse.php.internal.core.codeassist.ProposalExtraInfo;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionProposal;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionProposalLabelProvider;
import org.eclipse.php.internal.ui.editor.contentassist.PHPOverrideCompletionProposal;
import org.eclipse.php.internal.ui.editor.contentassist.ParameterGuessingProposal;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;

public class PHPCompletionProposalCollector
extends ScriptCompletionProposalCollector
implements IPHPCompletionRequestor {
    private static final String DOUBLE_COLON = "::";
    private static final String EMPTY_STRING = "";
    private IDocument document;
    private boolean explicit;
    private int offset;
    private int flags = 1;

    public PHPCompletionProposalCollector(IDocument document, ISourceModule cu, boolean explicit) {
        super(cu);
        this.document = document;
        this.explicit = explicit;
    }

    protected ScriptCompletionProposal createOverrideCompletionProposal(IScriptProject scriptProject, ISourceModule compilationUnit, String name, String[] paramTypes, int start, int length, StyledString label, String string) {
        return new PHPOverrideCompletionProposal(scriptProject, compilationUnit, name, paramTypes, start, length, label, string);
    }

    protected ScriptCompletionProposal createScriptCompletionProposal(String completion, int replaceStart, int length, Image image, StyledString displayString, int i) {
        return new PHPCompletionProposal(completion, replaceStart, length, image, displayString, i);
    }

    protected ScriptCompletionProposal createScriptCompletionProposal(String completion, int replaceStart, int length, Image image, StyledString displayString, int i, boolean isInDoc) {
        return new PHPCompletionProposal(completion, replaceStart, length, image, displayString, i, isInDoc);
    }

    protected IScriptCompletionProposal createPackageProposal(CompletionProposal proposal) {
        AbstractScriptCompletionProposal scriptProposal = (AbstractScriptCompletionProposal)super.createPackageProposal(proposal);
        IModelElement modelElement = proposal.getModelElement();
        if (modelElement != null) {
            scriptProposal.setProposalInfo((ICompletionProposalInfo)new ProposalInfo(modelElement.getScriptProject(), proposal.getName()));
        }
        return scriptProposal;
    }

    protected IScriptCompletionProposal createKeywordProposal(CompletionProposal proposal) {
        AbstractScriptCompletionProposal scriptProposal = (AbstractScriptCompletionProposal)super.createKeywordProposal(proposal);
        IModelElement modelElement = proposal.getModelElement();
        if (modelElement != null && modelElement.getElementType() == 5) {
            scriptProposal.setImage(PHPPluginImages.get("org.eclipse.php.ui.phpfile.png"));
        }
        return scriptProposal;
    }

    protected IScriptCompletionProposal createScriptCompletionProposal(CompletionProposal proposal) {
        ScriptCompletionProposal completionProposal;
        block4: {
            completionProposal = proposal.getKind() == 5 ? this.createMethodDeclarationProposal(proposal) : (proposal.getKind() == 7 ? (ScriptCompletionProposal)this.createTypeProposal(proposal) : (ScriptCompletionProposal)super.createScriptCompletionProposal(proposal));
            if (proposal.getKind() == 5) {
                IMethod method = (IMethod)proposal.getModelElement();
                try {
                    if (method.isConstructor()) {
                        int flags = proposal.getFlags();
                        ImageDescriptor typeImageDescriptor = ScriptElementImageProvider.getTypeImageDescriptor((int)flags, (boolean)false);
                        int adornmentFlags = ScriptElementImageProvider.computeAdornmentFlags((IModelElement)method.getDeclaringType(), (int)3);
                        ScriptElementImageDescriptor descriptor = new ScriptElementImageDescriptor(typeImageDescriptor, adornmentFlags, ScriptElementImageProvider.SMALL_SIZE);
                        completionProposal.setImage(this.getImage((ImageDescriptor)descriptor));
                    }
                }
                catch (ModelException e) {
                    if (!DLTKCore.DEBUG_COMPLETION) break block4;
                    e.printStackTrace();
                }
            }
        }
        return completionProposal;
    }

    protected char[] getVarTrigger() {
        return null;
    }

    public IDocument getDocument() {
        return this.document;
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    private ScriptCompletionProposal createMethodDeclarationProposal(final CompletionProposal proposal) {
        if (this.getSourceModule() == null || this.getSourceModule().getScriptProject() == null) {
            return null;
        }
        String name = proposal.getName();
        String completion = proposal.getCompletion();
        int replaceStart = proposal.getReplaceStart();
        String[] paramTypes = new String[]{};
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        StyledString label = ((PHPCompletionProposalLabelProvider)this.getLabelProvider()).createStyledOverrideMethodProposalLabel(proposal);
        StyledString displayString = ((PHPCompletionProposalLabelProvider)this.getLabelProvider()).createStyledMethodProposalLabel(proposal);
        ScriptCompletionProposal scriptProposal = null;
        if (ProposalExtraInfo.isNotInsertUse((Object)proposal.getExtraInfo())) {
            Image image = this.getImage(((PHPCompletionProposalLabelProvider)this.getLabelProvider()).createMethodImageDescriptor(proposal));
            scriptProposal = new PHPCompletionProposal(completion, replaceStart, length, image, displayString, 0){
                private boolean fReplacementStringComputed;
                {
                    super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
                    this.fReplacementStringComputed = false;
                }

                public String getReplacementString() {
                    if (!this.fReplacementStringComputed) {
                        String replacementString = this.computeReplacementString();
                        this.setReplacementString(replacementString);
                        this.fReplacementStringComputed = true;
                    }
                    return super.getReplacementString();
                }

                private String computeReplacementString() {
                    IMethod method = (IMethod)proposal.getModelElement();
                    if (ProposalExtraInfo.isMemberInNamespace((Object)proposal.getExtraInfo())) {
                        StringBuilder result = new StringBuilder(PHPModelUtils.getFullName((IMethod)method));
                        if (ProposalExtraInfo.isAbsoluteName((Object)this.getExtraInfo())) {
                            result.insert(0, '\\');
                        }
                        try {
                            if (PHPFlags.isNamespace((int)method.getFlags())) {
                                result.append('\\');
                            }
                        }
                        catch (ModelException e) {
                            PHPUiPlugin.log(e);
                        }
                        return result.toString();
                    }
                    if (ProposalExtraInfo.isNoInsert((Object)proposal.getExtraInfo())) {
                        return method.getElementName();
                    }
                    if (ProposalExtraInfo.isFullName((Object)proposal.getExtraInfo())) {
                        return PHPModelUtils.getFullName((IMethod)method);
                    }
                    return super.getReplacementString();
                }

                @Override
                public Object getExtraInfo() {
                    return proposal.getExtraInfo();
                }
            };
        } else {
            scriptProposal = this.createParameterGuessingProposal(proposal, name, paramTypes, start, length, label, completion, proposal.getExtraInfo());
        }
        scriptProposal.setImage(this.getImage(this.getLabelProvider().createMethodImageDescriptor(proposal)));
        MethodProposalInfo info = new MethodProposalInfo(this.getSourceModule().getScriptProject(), proposal);
        scriptProposal.setProposalInfo((ICompletionProposalInfo)info);
        scriptProposal.setRelevance(this.computeRelevance(proposal));
        return scriptProposal;
    }

    private ScriptCompletionProposal createParameterGuessingProposal(CompletionProposal proposal, String name, String[] paramTypes, int start, int length, StyledString label, String string, Object extraInfo) {
        return new ParameterGuessingProposal(proposal, this.getSourceModule().getScriptProject(), this.getSourceModule(), name, paramTypes, start, length, label, string, false, extraInfo, this.document);
    }

    protected IScriptCompletionProposal createTypeProposal(final CompletionProposal typeProposal) {
        String completion = typeProposal.getCompletion();
        int replaceStart = typeProposal.getReplaceStart();
        int length = this.getLength(typeProposal);
        Image image = this.getImage(((PHPCompletionProposalLabelProvider)this.getLabelProvider()).createTypeImageDescriptor(typeProposal));
        StyledString displayString = ((PHPCompletionProposalLabelProvider)this.getLabelProvider()).createStyledTypeProposalLabel(typeProposal);
        PHPCompletionProposal scriptProposal = new PHPCompletionProposal(completion, replaceStart, length, image, displayString, 0){
            private boolean fReplacementStringComputed;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
                this.fReplacementStringComputed = false;
            }

            public String getReplacementString() {
                if (!this.fReplacementStringComputed) {
                    String replacementString = this.computeReplacementString();
                    if (ProposalExtraInfo.isAddQuote((Object)typeProposal.getExtraInfo())) {
                        replacementString = "'" + replacementString + "'";
                    }
                    this.setReplacementString(replacementString);
                    this.fReplacementStringComputed = true;
                }
                return super.getReplacementString();
            }

            private String computeReplacementString() {
                IType type = (IType)typeProposal.getModelElement();
                if (ProposalExtraInfo.isMemberInNamespace((Object)typeProposal.getExtraInfo())) {
                    StringBuilder result = new StringBuilder(PHPModelUtils.getFullName((IType)type));
                    if (ProposalExtraInfo.isAbsoluteName((Object)this.getExtraInfo())) {
                        result.insert(0, '\\');
                    }
                    try {
                        if (PHPFlags.isNamespace((int)type.getFlags())) {
                            result.append('\\');
                        }
                    }
                    catch (ModelException e) {
                        PHPUiPlugin.log(e);
                    }
                    return result.toString();
                }
                String prefix = PHPCompletionProposalCollector.EMPTY_STRING;
                try {
                    int flags = type.getFlags();
                    IType currentNamespace = PHPModelUtils.getCurrentNamespaceIfAny((ISourceModule)PHPCompletionProposalCollector.this.getSourceModule(), (int)this.getReplacementOffset());
                    IType namespace = PHPModelUtils.getCurrentNamespace((IModelElement)type);
                    if (!PHPFlags.isNamespace((int)flags) && namespace == null && currentNamespace != null && !ProjectOptions.getPHPVersion((IProject)PHPCompletionProposalCollector.this.getScriptProject().getProject()).isLessThan(PHPVersion.PHP5_3) && PHPCompletionProposalCollector.this.document.getChar(this.getReplacementOffset() - 1) != '\\') {
                        prefix = String.valueOf(prefix) + '\\';
                    }
                }
                catch (ModelException e) {
                    PHPUiPlugin.log(e);
                }
                catch (BadLocationException e) {
                    PHPUiPlugin.log(e);
                }
                String suffix = this.getSuffix(type);
                String replacementString = null;
                replacementString = typeProposal.getModelElement() instanceof AliasType ? ((AliasType)typeProposal.getModelElement()).getAlias() : super.getReplacementString();
                return String.valueOf(prefix) + replacementString + suffix;
            }

            public String getSuffix(IType type) {
                String defaultResult = PHPCompletionProposalCollector.EMPTY_STRING;
                boolean cfr_ignored_0 = type instanceof AliasType;
                if (ProposalExtraInfo.isTypeOnly((Object)typeProposal.getExtraInfo()) || !PHPModelUtils.hasStaticOrConstMember((IType)type)) {
                    return defaultResult;
                }
                String nextWord = null;
                try {
                    nextWord = PHPCompletionProposalCollector.this.document.get(this.getReplacementOffset() + this.getReplacementLength(), 2);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                return PHPCompletionProposalCollector.DOUBLE_COLON.equals(nextWord) ? defaultResult : PHPCompletionProposalCollector.DOUBLE_COLON;
            }

            @Override
            public Object getExtraInfo() {
                return typeProposal.getExtraInfo();
            }
        };
        scriptProposal.setRelevance(this.computeRelevance(typeProposal));
        scriptProposal.setProposalInfo((ICompletionProposalInfo)new TypeProposalInfo(this.getSourceModule().getScriptProject(), typeProposal));
        return scriptProposal;
    }

    protected IScriptCompletionProposal createFieldProposal(final CompletionProposal proposal) {
        String completion = String.valueOf(proposal.getCompletion());
        int start = proposal.getReplaceStart();
        int length = this.getLength(proposal);
        StyledString displayString = ((PHPCompletionProposalLabelProvider)this.getLabelProvider()).createStyledFieldProposalLabel(proposal);
        Image image = this.getImage(((PHPCompletionProposalLabelProvider)this.getLabelProvider()).createFieldImageDescriptor(proposal));
        PHPCompletionProposal scriptProposal = new PHPCompletionProposal(completion, start, length, image, displayString, 0){
            private boolean fReplacementStringComputed;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
                this.fReplacementStringComputed = false;
            }

            public String getReplacementString() {
                if (!this.fReplacementStringComputed) {
                    String replacementString = this.computeReplacementString();
                    if (ProposalExtraInfo.isAddQuote((Object)proposal.getExtraInfo())) {
                        replacementString = "'" + replacementString + "'";
                    }
                    this.setReplacementString(replacementString);
                    this.fReplacementStringComputed = true;
                }
                return super.getReplacementString();
            }

            private String computeReplacementString() {
                IField field = (IField)proposal.getModelElement();
                if (ProposalExtraInfo.isMemberInNamespace((Object)proposal.getExtraInfo())) {
                    StringBuilder result = new StringBuilder(PHPModelUtils.getFullName((IField)field));
                    if (ProposalExtraInfo.isAbsoluteName((Object)this.getExtraInfo())) {
                        result.insert(0, '\\');
                    }
                    try {
                        if (PHPFlags.isNamespace((int)field.getFlags())) {
                            result.append('\\');
                        }
                    }
                    catch (ModelException e) {
                        PHPUiPlugin.log(e);
                    }
                    return result.toString();
                }
                if (field instanceof AliasField) {
                    AliasField aliasField = (AliasField)field;
                    return aliasField.getAlias();
                }
                if (ProposalExtraInfo.isNoInsert((Object)proposal.getExtraInfo())) {
                    return field.getElementName();
                }
                if (ProposalExtraInfo.isFullName((Object)proposal.getExtraInfo())) {
                    return PHPModelUtils.getFullName((IField)field);
                }
                return super.getReplacementString();
            }

            @Override
            public Object getExtraInfo() {
                return proposal.getExtraInfo();
            }
        };
        if (this.getSourceModule().getScriptProject() != null) {
            scriptProposal.setProposalInfo((ICompletionProposalInfo)new FieldProposalInfo(this.getSourceModule().getScriptProject(), proposal));
        }
        scriptProposal.setRelevance(this.computeRelevance(proposal));
        scriptProposal.setTriggerCharacters(this.getVarTrigger());
        return scriptProposal;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    protected String getNatureId() {
        return "org.eclipse.php.core.PHPNature";
    }

    public int computeRelevance(CompletionProposal proposal) {
        if (proposal.getModelElement() instanceof IMethod && ProposalExtraInfo.isMagicMethod((Object)proposal.getExtraInfo())) {
            return -1;
        }
        if (proposal.getModelElement() instanceof IField && ProposalExtraInfo.isMagicMethod((Object)proposal.getExtraInfo())) {
            return Integer.MAX_VALUE;
        }
        return super.computeRelevance(proposal);
    }

    public boolean filter(int flag) {
        return (this.flags & flag) != 0;
    }

    public void addFlag(int flag) {
        this.flags |= flag;
    }
}

