/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.core.pdi.aif;

import org.eclipse.ptp.debug.core.pdi.model.aif.AIFFormatException;
import org.eclipse.ptp.debug.core.pdi.model.aif.ITypeIntegral;
import org.eclipse.ptp.internal.debug.core.pdi.aif.AIFType;
import org.eclipse.ptp.internal.debug.core.pdi.messages.Messages;
import org.eclipse.ptp.internal.debug.core.pdi.model.aif.AIFFactory;

public abstract class TypeIntegral
extends AIFType
implements ITypeIntegral {
    private boolean fSigned;
    private int fSize;

    @Override
    public boolean isSigned() {
        return this.fSigned;
    }

    public String toString() {
        return String.valueOf(this.isSigned() ? String.valueOf('s') : String.valueOf('u')) + this.sizeof();
    }

    @Override
    public String parse(String fmt) throws AIFFormatException {
        this.fSigned = fmt.charAt(0) == 's';
        int pos = AIFFactory.getFirstNonDigitPos(fmt, 1, false);
        if (pos == -1) {
            throw new AIFFormatException(Messages.TypeIntegral_0);
        }
        this.fSize = Integer.parseInt(fmt.substring(1, pos));
        return fmt.substring(pos);
    }

    @Override
    public int sizeof() {
        return this.fSize;
    }
}

