/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rm.lml.ui.views;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ptp.internal.rm.lml.ui.messages.Messages;
import org.eclipse.ptp.rm.lml.core.LMLManager;
import org.eclipse.ptp.rm.lml.core.elements.ObjectType;
import org.eclipse.ptp.rm.lml.core.events.ILguiAddedEvent;
import org.eclipse.ptp.rm.lml.core.events.ILguiRemovedEvent;
import org.eclipse.ptp.rm.lml.core.events.IMarkObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.INodedisplayZoomEvent;
import org.eclipse.ptp.rm.lml.core.events.ISelectObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.ITableFilterEvent;
import org.eclipse.ptp.rm.lml.core.events.ITableSortedEvent;
import org.eclipse.ptp.rm.lml.core.events.IUnmarkObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.IUnselectedObjectEvent;
import org.eclipse.ptp.rm.lml.core.events.IViewUpdateEvent;
import org.eclipse.ptp.rm.lml.core.listeners.ILMLListener;
import org.eclipse.ptp.rm.lml.core.listeners.INodedisplayZoomListener;
import org.eclipse.ptp.rm.lml.core.model.ILguiItem;
import org.eclipse.ptp.rm.lml.internal.ui.UIUtils;
import org.eclipse.ptp.rm.lml.ui.providers.AbstractNodedisplayView;
import org.eclipse.ptp.rm.lml.ui.providers.NodedisplayView;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class NodesView
extends ViewPart {
    private Composite composite = null;
    private AbstractNodedisplayView nodedisplayView = null;
    public Viewer viewer;
    public ILguiItem fLguiItem = null;
    private final ILMLListener lguiListener = new LguiListener();
    private final LMLManager lmlManager = LMLManager.getInstance();
    private String gid = null;
    private Action incAction;
    private Action decAction;

    public void createPartControl(Composite parent) {
        this.gid = this.getViewSite().getId();
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new FillLayout());
        this.composite.setBackground(this.composite.getDisplay().getSystemColor(1));
        this.fLguiItem = this.lmlManager.getSelectedLguiItem();
        this.lmlManager.addListener(this.lguiListener, ((Object)((Object)this)).getClass().getName());
        this.nodedisplayView = new NodedisplayView(null, null, this.composite);
        if (this.fLguiItem != null) {
            this.nodedisplayView.update(this.fLguiItem);
        }
        this.nodedisplayView.addZoomListener(new INodedisplayZoomListener(){

            public void handleEvent(INodedisplayZoomEvent event) {
                UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        NodesView.this.checkActionStates();
                    }
                });
            }
        });
        this.createToolbar();
        this.composite.layout();
    }

    public void dispose() {
        this.lmlManager.removeListener(this.lguiListener);
    }

    public void setFocus() {
    }

    protected void checkActionStates() {
        if (this.nodedisplayView == null || !this.nodedisplayView.isVisible()) {
            this.decAction.setEnabled(false);
            this.incAction.setEnabled(false);
        } else {
            this.decAction.setEnabled(this.nodedisplayView.getShownMaxLevel() > this.nodedisplayView.getMinimumLevelOfDetail());
            this.incAction.setEnabled(this.nodedisplayView.getShownMaxLevel() < this.nodedisplayView.getMaximumNodedisplayDepth());
        }
    }

    protected void createToolbar() {
        this.incAction = new Action(Messages.NodesView_0){

            public void run() {
                if (NodesView.this.nodedisplayView != null) {
                    NodesView.this.nodedisplayView.setMaxLevel(NodesView.this.nodedisplayView.getShownMaxLevel() + 1);
                    NodesView.this.nodedisplayView.update();
                }
                NodesView.this.checkActionStates();
            }
        };
        this.decAction = new Action(Messages.NodesView_1){

            public void run() {
                if (NodesView.this.nodedisplayView != null && NodesView.this.nodedisplayView.getShownMaxLevel() > NodesView.this.nodedisplayView.getMinimumLevelOfDetail()) {
                    NodesView.this.nodedisplayView.setMaxLevel(NodesView.this.nodedisplayView.getShownMaxLevel() - 1);
                    NodesView.this.nodedisplayView.update();
                }
                NodesView.this.checkActionStates();
            }
        };
        ImageDescriptor zoomIn = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD");
        ImageDescriptor zoomOut = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK");
        this.incAction.setImageDescriptor(zoomIn);
        this.decAction.setImageDescriptor(zoomOut);
        this.incAction.setToolTipText(Messages.NodesView_2);
        this.decAction.setToolTipText(Messages.NodesView_3);
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolbarManager.add((IAction)this.decAction);
        toolbarManager.add((IAction)this.incAction);
        this.checkActionStates();
    }

    private final class LguiListener
    implements ILMLListener {
        private LguiListener() {
        }

        public void handleEvent(ILguiAddedEvent event) {
            UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((LguiListener)LguiListener.this).NodesView.this.fLguiItem = NodesView.this.lmlManager.getSelectedLguiItem();
                    if (!NodesView.this.nodedisplayView.isDisposed()) {
                        NodesView.this.nodedisplayView.update(((LguiListener)LguiListener.this).NodesView.this.fLguiItem);
                        NodesView.this.nodedisplayView.setVisible(true);
                        NodesView.this.checkActionStates();
                    }
                    if (((LguiListener)LguiListener.this).NodesView.this.fLguiItem != null && ((LguiListener)LguiListener.this).NodesView.this.fLguiItem.getNodedisplayAccess() != null) {
                        NodesView.this.setPartName(((LguiListener)LguiListener.this).NodesView.this.fLguiItem.getNodedisplayAccess().getTitle(NodesView.this.gid));
                    }
                }
            });
        }

        public void handleEvent(ILguiRemovedEvent event) {
            UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    if (!NodesView.this.nodedisplayView.isDisposed()) {
                        NodesView.this.nodedisplayView.setVisible(false);
                    }
                    ((LguiListener)LguiListener.this).NodesView.this.fLguiItem = null;
                    NodesView.this.setPartName("System Monitoring");
                    NodesView.this.checkActionStates();
                }
            });
        }

        public void handleEvent(IMarkObjectEvent event) {
            if (NodesView.this.fLguiItem != null && NodesView.this.fLguiItem.getObjectStatus() != null) {
                NodesView.this.fLguiItem.getObjectStatus().mouseDown(event.getOid());
            }
        }

        public void handleEvent(ISelectObjectEvent event) {
            if (NodesView.this.fLguiItem != null && NodesView.this.fLguiItem.getObjectStatus() != null) {
                NodesView.this.fLguiItem.getObjectStatus().mouseOver(event.getOid());
            }
        }

        public void handleEvent(ITableFilterEvent event) {
        }

        public void handleEvent(ITableSortedEvent e) {
        }

        public void handleEvent(IUnmarkObjectEvent event) {
            if (NodesView.this.fLguiItem != null && NodesView.this.fLguiItem.getObjectStatus() != null) {
                NodesView.this.fLguiItem.getObjectStatus().mouseUp(event.getOid());
            }
        }

        public void handleEvent(IUnselectedObjectEvent event) {
            if (NodesView.this.fLguiItem != null && NodesView.this.fLguiItem.getOIDToObject() != null && NodesView.this.fLguiItem.getObjectStatus() != null) {
                ObjectType object = NodesView.this.fLguiItem.getOIDToObject().getObjectById(event.getOid());
                NodesView.this.fLguiItem.getObjectStatus().mouseexit(object);
            }
        }

        public void handleEvent(IViewUpdateEvent event) {
            UIUtils.safeRunSyncInUIThread((ISafeRunnable)new SafeRunnable(){

                public void run() throws Exception {
                    ((LguiListener)LguiListener.this).NodesView.this.fLguiItem = NodesView.this.lmlManager.getSelectedLguiItem();
                    if (!NodesView.this.nodedisplayView.isDisposed()) {
                        NodesView.this.nodedisplayView.update(((LguiListener)LguiListener.this).NodesView.this.fLguiItem);
                        NodesView.this.nodedisplayView.setVisible(true);
                        NodesView.this.checkActionStates();
                    }
                    if (((LguiListener)LguiListener.this).NodesView.this.fLguiItem != null && ((LguiListener)LguiListener.this).NodesView.this.fLguiItem.getNodedisplayAccess() != null) {
                        NodesView.this.setPartName(((LguiListener)LguiListener.this).NodesView.this.fLguiItem.getNodedisplayAccess().getTitle(NodesView.this.gid));
                    }
                }
            });
        }
    }
}

