/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.models;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.eclipse.recommenders.models.IInputStreamTransformer;
import org.eclipse.recommenders.models.IModelArchiveCoordinateAdvisor;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.SimpleModelProvider;
import org.eclipse.recommenders.utils.Throws;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PoolingModelProvider<K extends IUniqueName<?>, M>
extends SimpleModelProvider<K, M> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final IdentityHashMap<M, K> borrowedModels = new IdentityHashMap();
    private GenericKeyedObjectPool<K, M> pool = this.createModelPool();

    public PoolingModelProvider(IModelRepository repository, IModelArchiveCoordinateAdvisor index, String modelType, Map<String, IInputStreamTransformer> transformers) {
        super(repository, index, modelType, transformers);
    }

    private GenericKeyedObjectPool<K, M> createModelPool() {
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new ModelPoolFactoryMediator());
        pool.setMaxTotal(30);
        pool.setMaxIdle(5);
        pool.setWhenExhaustedAction((byte)0);
        pool.setTimeBetweenEvictionRunsMillis(TimeUnit.MINUTES.toMillis(5L));
        pool.setMinEvictableIdleTimeMillis(TimeUnit.MINUTES.toMillis(5L));
        return pool;
    }

    @Override
    public Optional<M> acquireModel(K key) {
        if (key == null) {
            return Optional.absent();
        }
        try {
            Object model = this.pool.borrowObject(key);
            this.borrowedModels.put(model, key);
            return Optional.of((Object)model);
        }
        catch (Exception exception) {
            return Optional.absent();
        }
    }

    @Override
    public void releaseModel(M model) {
        if (model == null) {
            return;
        }
        try {
            IUniqueName key = (IUniqueName)this.borrowedModels.remove(model);
            this.pool.returnObject((Object)key, model);
        }
        catch (Exception e) {
            this.log.error("Exception while releasing. Couldn't release model " + model, (Throwable)e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
            this.pool.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected void activateModel(M model) {
    }

    protected void passivateModel(M model) {
    }

    protected void destroyModel(M model) {
    }

    private final class ModelPoolFactoryMediator
    extends BaseKeyedPoolableObjectFactory<K, M> {
        private ModelPoolFactoryMediator() {
        }

        public M makeObject(K key) throws Exception {
            Object result = PoolingModelProvider.super.acquireModel(key).orNull();
            if (result == null) {
                Throws.throwCancelationException((String)"Model not found for key '%s'", (Object[])new Object[]{key});
            }
            return result;
        }

        public void activateObject(K key, M obj) throws Exception {
            PoolingModelProvider.this.activateModel(obj);
        }

        public void passivateObject(K key, M obj) throws Exception {
            PoolingModelProvider.this.passivateModel(obj);
        }

        public void destroyObject(K key, M obj) throws Exception {
            PoolingModelProvider.this.destroyModel(obj);
        }
    }
}

