/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.List;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.annotations.Documentation;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.services.DocumentationService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.internal.StandardDocumentationService;

public final class StandardElementDocumentationService
extends StandardDocumentationService {
    @Override
    protected void initStandardDocumentationService(StringBuilder content, List<DocumentationService.Topic> topics) {
        ElementType type = this.context(ElementType.class);
        Documentation docAnnotation = type.getAnnotation(Documentation.class);
        if (docAnnotation != null) {
            LocalizationService localization = type.getLocalizationService();
            String docAnnotationContent = localization.text(docAnnotation.content().trim(), CapitalizationType.NO_CAPS, false);
            if (docAnnotationContent.length() > 0) {
                content.append(docAnnotationContent);
            }
            topics.addAll(StandardElementDocumentationService.convert(docAnnotation.topics(), localization));
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            return context.find(ElementType.class).hasAnnotation(Documentation.class);
        }
    }
}

