/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.layout;

import org.eclipse.draw2d.graph.DirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.sapphire.ui.swt.gef.layout.DummyEdgePart;

public class DummyEdgeCreator {
    private NodeList nodeList;
    private EdgeList edgeList;

    public void visit(DirectedGraph g) {
        this.init(g);
        this.setDummyEdges();
    }

    private void init(DirectedGraph graph) {
        this.nodeList = graph.nodes;
        this.edgeList = graph.edges;
    }

    protected void setDummyEdges() {
        int nodeCount = this.nodeList.size();
        if (nodeCount > 1) {
            NodeList candidateList = new NodeList();
            for (Node sourceNode : this.nodeList) {
                if (sourceNode.outgoing.size() == 0 && sourceNode.incoming.size() == 0) {
                    candidateList.add((Object)sourceNode);
                    sourceNode.setRowConstraint(2);
                    continue;
                }
                sourceNode.setRowConstraint(1);
            }
            if (candidateList.size() > 1) {
                int index = 0;
                while (index < candidateList.size() - 1) {
                    Node sourceNode;
                    sourceNode = candidateList.getNode(index++);
                    Node targetNode = candidateList.getNode(index);
                    this.newDummyEdge(targetNode, sourceNode);
                }
            }
        }
    }

    private Edge newDummyEdge(Node targetNode, Node sourceNode) {
        DummyEdgePart edgePart = new DummyEdgePart();
        Edge edge = new Edge((Object)edgePart, sourceNode, targetNode);
        edge.weight = 1;
        this.edgeList.add((Object)edge);
        return edge;
    }
}

