/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.sapphire.ui.Bounds;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.diagram.editor.ContainerShapePart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodeBounds;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;
import org.eclipse.sapphire.ui.swt.gef.model.ContainerShapeModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramModelBase;
import org.eclipse.sapphire.ui.swt.gef.model.ShapeModel;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramNodePresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;

public class DiagramNodeModel
extends DiagramModelBase {
    public static final String SOURCE_CONNECTIONS = "SOURCE_CONNECTIONS";
    public static final String TARGET_CONNECTIONS = "TARGET_CONNECTIONS";
    public static final String NODE_BOUNDS = "NODE_BOUNDS";
    public static final String SHAPE_VISIBILITY_UPDATES = "SHAPE_VISIBILITY_UPDATES";
    public static final String NODE_START_EDITING = "NODE_START_EDITING";
    private DiagramModel parent;
    private DiagramNodePresentation nodePresentation;
    private List<DiagramConnectionModel> sourceConnections = new ArrayList<DiagramConnectionModel>();
    private List<DiagramConnectionModel> targetConnections = new ArrayList<DiagramConnectionModel>();
    private ShapePresentation shapePresentation;
    private ShapeModel shapeModel;

    public DiagramNodeModel(DiagramModel parent, DiagramNodePresentation nodePresentation) {
        this.parent = parent;
        this.nodePresentation = nodePresentation;
        this.shapePresentation = this.nodePresentation.getShapePresentation();
        this.shapeModel = ShapeModel.ShapeModelFactory.createShapeModel(this, null, this.shapePresentation);
        this.nodePresentation.init(this);
    }

    public DiagramModel getDiagramModel() {
        return this.parent;
    }

    public DiagramNodePresentation getNodePresentation() {
        return this.nodePresentation;
    }

    @Override
    public SapphirePart getSapphirePart() {
        return this.getModelPart();
    }

    public DiagramNodePart getModelPart() {
        return this.nodePresentation.part();
    }

    public String getLabel() {
        ContainerShapePart containerShapePart;
        List textParts;
        ShapePart shapePart = this.getModelPart().getShapePart();
        if (shapePart instanceof ContainerShapePart && !(textParts = ShapePart.getContainedShapeParts((ShapePart)(containerShapePart = (ContainerShapePart)shapePart), TextPart.class)).isEmpty()) {
            return ((TextPart)textParts.get(0)).getContent();
        }
        return null;
    }

    public Bounds getNodeBounds() {
        DiagramNodeBounds bounds = this.getModelPart().getNodeBounds();
        return bounds;
    }

    public void handleMoveNode() {
        this.firePropertyChange(NODE_BOUNDS, null, this.getModelPart().getNodeBounds());
    }

    public void handleVisibilityChange(ShapePart shapePart) {
        if (this.getShapeModel() instanceof ContainerShapeModel) {
            ((ContainerShapeModel)this.getShapeModel()).refreshChildren();
        }
        this.firePropertyChange(SHAPE_VISIBILITY_UPDATES, null, shapePart);
    }

    public List<DiagramConnectionModel> getSourceConnections() {
        return this.sourceConnections;
    }

    public List<DiagramConnectionModel> getTargetConnections() {
        return this.targetConnections;
    }

    public void addSourceConnection(DiagramConnectionModel connection) {
        this.sourceConnections.add(connection);
        this.firePropertyChange(SOURCE_CONNECTIONS, null, connection);
    }

    public void addTargetConnection(DiagramConnectionModel connection) {
        this.targetConnections.add(connection);
        this.firePropertyChange(TARGET_CONNECTIONS, null, connection);
    }

    public void removeSourceConnection(DiagramConnectionModel connection) {
        this.sourceConnections.remove(connection);
        this.firePropertyChange(SOURCE_CONNECTIONS, null, connection);
    }

    public void removeTargetConnection(DiagramConnectionModel connection) {
        this.targetConnections.remove(connection);
        this.firePropertyChange(TARGET_CONNECTIONS, null, connection);
    }

    public void handleStartEditing() {
        this.firePropertyChange(NODE_START_EDITING, null, null);
    }

    public void handleStartEditing(ShapePart shapePart) {
        this.firePropertyChange(NODE_START_EDITING, null, shapePart);
    }

    public String toString() {
        return this.getLabel();
    }

    public ShapeModel getShapeModel() {
        return this.shapeModel;
    }

    public ShapePresentation getShapePresentation() {
        return this.shapePresentation;
    }
}

