/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.presentation;

import org.eclipse.draw2d.IFigure;
import org.eclipse.sapphire.Color;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ui.diagram.editor.ShapePart;
import org.eclipse.sapphire.ui.diagram.editor.TextChangeEvent;
import org.eclipse.sapphire.ui.diagram.editor.TextPart;
import org.eclipse.sapphire.ui.diagram.shape.def.FontDef;
import org.eclipse.sapphire.ui.swt.gef.figures.TextFigure;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramResourceCache;
import org.eclipse.sapphire.ui.swt.gef.presentation.DiagramPresentation;
import org.eclipse.sapphire.ui.swt.gef.presentation.ShapePresentation;

public class TextPresentation
extends ShapePresentation {
    private Listener textChangeListener = new FilteredListener<TextChangeEvent>(){

        protected void handleTypedEvent(TextChangeEvent event) {
            TextPresentation.this.refresh();
        }
    };

    public TextPresentation(DiagramPresentation parent, TextPart textPart, DiagramResourceCache resourceCache) {
        super(parent, (ShapePart)textPart, resourceCache);
        this.part().attach(this.textChangeListener);
    }

    public Color getTextColor() {
        return this.part().getTextColor();
    }

    public String getContent() {
        return this.part().getContent();
    }

    public FontDef getFontDef() {
        return this.part().getFontDef();
    }

    public boolean truncatable() {
        return this.part().truncatable();
    }

    @Override
    public void refreshVisuals() {
        super.refreshVisuals();
        if (this.getFigure() != null) {
            TextFigure textFigure = (TextFigure)this.getFigure();
            textFigure.setText(this.part().getContent());
        }
    }

    public TextPart part() {
        return (TextPart)super.part();
    }

    @Override
    public void render() {
        TextFigure figure = null;
        if (this.visible()) {
            figure = new TextFigure(this.getResourceCache(), this);
        }
        this.setFigure((IFigure)figure);
    }

    @Override
    public void dispose() {
        this.part().detach(this.textChangeListener);
    }

    private void refresh() {
        TextFigure textFigure = (TextFigure)this.getFigure();
        textFigure.setText(this.getContent());
    }
}

