/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms.swt.internal;

import org.eclipse.sapphire.ImageData;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.modeling.EnumValueType;
import org.eclipse.sapphire.services.ValueImageService;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.AbstractBinding;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.RadioButtonsGroup;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public final class RadioButtonGroupBinding
extends AbstractBinding {
    @Text(value="<value not set>")
    private static LocalizableText nullValueLabel;
    private RadioButtonsGroup buttonsGroup;
    private Button badValueButton;
    private Enum<?>[] enumValues;

    static {
        LocalizableText.init(RadioButtonGroupBinding.class);
    }

    public RadioButtonGroupBinding(PropertyEditorPresentation propertyEditorPresentation, RadioButtonsGroup buttonsGroup) {
        super(propertyEditorPresentation, (Control)buttonsGroup);
    }

    @Override
    protected void initialize(PropertyEditorPresentation propertyEditorPresentation, Control control) {
        super.initialize(propertyEditorPresentation, control);
        this.enumValues = (Enum[])this.property().definition().getTypeClass().getEnumConstants();
        this.buttonsGroup = (RadioButtonsGroup)control;
        PropertyEditorPart part = propertyEditorPresentation.part();
        Property property = part.property();
        EnumValueType enumValueType = new EnumValueType(this.enumValues[0].getDeclaringClass());
        Enum<?>[] enumArray = this.enumValues;
        int n = this.enumValues.length;
        int n2 = 0;
        while (n2 < n) {
            Enum<?> enumItem = enumArray[n2];
            String enumItemStr = (String)((MasterConversionService)property.service(MasterConversionService.class)).convert(enumItem, String.class);
            String auxText = part.getRenderingHint("aux.text." + enumItemStr, null);
            ValueImageService imageService = (ValueImageService)property.service(ValueImageService.class);
            ImageData imageData = imageService.provide(enumItemStr);
            Image image = propertyEditorPresentation.resources().image(imageData);
            Button button = this.buttonsGroup.addRadioButton(enumValueType.getLabel(enumItem, false, CapitalizationType.FIRST_WORD_ONLY, true), auxText, image);
            button.setData(enumItem);
            ++n2;
        }
        this.buttonsGroup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RadioButtonGroupBinding.this.updateModel();
                RadioButtonGroupBinding.this.updateTargetAttributes();
            }
        });
    }

    private int getSelectionIndex() {
        return this.buttonsGroup.getSelectionIndex();
    }

    private void setSelectionIndex(int index) {
        this.buttonsGroup.setSelectionIndex(index);
    }

    private void createMalformedItem(String label) {
        if (this.badValueButton == null) {
            this.badValueButton = this.buttonsGroup.addRadioButton("");
        }
        this.badValueButton.setText(label);
        this.presentation().layout();
    }

    private void removeMalformedItem() {
        if (!this.buttonsGroup.isDisposed() && this.badValueButton != null) {
            this.badValueButton.dispose();
            this.badValueButton = null;
            this.presentation().layout();
        }
    }

    public Value<Enum<?>> property() {
        return (Value)super.property();
    }

    @Override
    protected final void doUpdateModel() {
        int index = this.getSelectionIndex();
        if (index >= 0 && index < this.enumValues.length) {
            this.property().write(this.enumValues[index], true);
            this.removeMalformedItem();
        }
    }

    @Override
    protected final void doUpdateTarget() {
        int existingSelection = this.getSelectionIndex();
        Value<Enum<?>> value = this.property();
        int newSelection = this.enumValues.length;
        if (!value.malformed()) {
            Enum newValueEnum = (Enum)value.content(true);
            int i = 0;
            int n = this.enumValues.length;
            while (i < n) {
                if (this.enumValues[i] == newValueEnum) {
                    newSelection = i;
                    break;
                }
                ++i;
            }
        }
        if (newSelection == this.enumValues.length) {
            String newValueString = value.text(true);
            String label = newValueString == null ? nullValueLabel.text() : newValueString;
            this.createMalformedItem(label);
        } else {
            this.removeMalformedItem();
        }
        if (existingSelection != newSelection) {
            this.setSelectionIndex(newSelection);
        }
    }
}

