/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sirius.common.tools.internal.resource.WorkspaceBackend;

public class ResourceDeltaVisitor
implements IResourceDeltaVisitor {
    private Collection<Resource> addedResources = new ArrayList<Resource>();
    private Collection<Resource> changedResources = new ArrayList<Resource>();
    private Collection<Resource> removedResources = new ArrayList<Resource>();
    private Collection<Resource> initialresources;
    private WorkspaceBackend workspaceBackend;

    public ResourceDeltaVisitor(WorkspaceBackend workspaceBackend) {
        this.workspaceBackend = workspaceBackend;
        this.initialresources = new ArrayList<Resource>((Collection<Resource>)this.workspaceBackend.getObservedSet().getResources());
    }

    public boolean visit(IResourceDelta delta) {
        if (!this.isMarkerNotification(delta) && !this.isTeamSyncNotification(delta) && this.isAboutFileChange(delta)) {
            this.processDelta(delta);
        }
        return true;
    }

    private boolean isAboutFileChange(IResourceDelta delta) {
        return delta.getResource().getType() == 1;
    }

    private boolean isMarkerNotification(IResourceDelta delta) {
        return delta.getFlags() == 131072;
    }

    private boolean isTeamSyncNotification(IResourceDelta delta) {
        return delta.getFlags() == 65536;
    }

    private void processDelta(IResourceDelta delta) {
        URI uri;
        Resource resource;
        if ((delta.getKind() & 7) != 0 && delta.getFullPath() != null && (resource = this.alreadyContainsResource(uri = URI.createURI((String)delta.getFullPath().toString(), (boolean)true), false)) != null) {
            if ((delta.getKind() & 2) != 0) {
                this.removedResources.add(resource);
            } else if ((delta.getKind() & 4) != 0) {
                this.changedResources.add(resource);
            } else {
                this.addedResources.add(resource);
            }
        }
    }

    private Resource alreadyContainsResource(URI uri, boolean loadOnDemand) {
        Resource resource;
        Resource alreadyContainsResource = null;
        Map map = ((ResourceSetImpl)this.workspaceBackend.getObservedSet()).getURIResourceMap();
        if (map != null && (resource = (Resource)map.get(uri)) != null) {
            alreadyContainsResource = resource;
        }
        if (alreadyContainsResource == null) {
            Resource delegatedResource;
            URIConverter theURIConverter = this.workspaceBackend.getObservedSet().getURIConverter();
            URI normalizedURI = theURIConverter.normalize(uri);
            for (Resource resource2 : this.initialresources) {
                URI resourceNormalizedURI = URI.createURI((String)"");
                try {
                    resourceNormalizedURI = this.workspaceBackend.getObservedSet().getURIConverter().normalize(resource2.getURI());
                }
                catch (IllegalStateException illegalStateException) {}
                if (!resourceNormalizedURI.equals(normalizedURI)) continue;
                if (map != null) {
                    map.put(uri, resource2);
                }
                alreadyContainsResource = resource2;
                break;
            }
            if (alreadyContainsResource == null && (delegatedResource = this.delegatedGetResource(uri, loadOnDemand)) != null) {
                if (map != null) {
                    map.put(uri, delegatedResource);
                }
                alreadyContainsResource = delegatedResource;
            }
        }
        return alreadyContainsResource;
    }

    protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
        EPackage ePackage = this.workspaceBackend.getObservedSet().getPackageRegistry().getEPackage(uri.toString());
        return ePackage == null ? null : ePackage.eResource();
    }

    public Collection<Resource> getAddedResources() {
        return this.addedResources;
    }

    public Collection<Resource> getChangedResources() {
        return this.changedResources;
    }

    public Collection<Resource> getRemovedResources() {
        return this.removedResources;
    }
}

