/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.internal.services;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.persistence.history.HistoryManager;
import org.eclipse.tcf.te.runtime.services.AbstractService;
import org.eclipse.tcf.te.tcf.locator.interfaces.IPeerModelListener;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IDefaultContextService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IPeerModelLookupService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityManagerListener;

public class DefaultContextService
extends AbstractService
implements IDefaultContextService,
IPeerModelListener,
IActivityManagerListener {
    private static final String PART_ID_TE_VIEW = "org.eclipse.tcf.te.ui.views.View";

    public DefaultContextService() {
        ModelManager.getPeerModel().addListener((IPeerModelListener)this);
        IActivityManager manager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
        manager.addActivityManagerListener((IActivityManagerListener)this);
    }

    public IPeerNode[] getCandidates(Object currentSelection, IDefaultContextService.IContextFilter filter) {
        ArrayList<IPeerNode> candidates = new ArrayList<IPeerNode>();
        if (currentSelection instanceof IStructuredSelection) {
            this.addCandidates((IStructuredSelection)currentSelection, filter, candidates);
        }
        this.addCandidates(this.getDefaultSelections(filter), filter, candidates);
        this.addCandidates(this.getEditorSelection(), filter, candidates);
        this.addCandidates(this.getPartSelection(PART_ID_TE_VIEW), filter, candidates);
        return candidates.toArray(new IPeerNode[candidates.size()]);
    }

    public void setDefaultContext(IPeerNode peerNode) {
        if (peerNode != null) {
            HistoryManager.getInstance().add(((Object)((Object)this)).getClass().getName(), peerNode.getPeerId());
            EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)this, (Object)"added", (Object)peerNode, (Object)peerNode));
        }
    }

    public IPeerNode getDefaultContext(IDefaultContextService.IContextFilter filter) {
        String[] stringArray = HistoryManager.getInstance().getHistory(((Object)((Object)this)).getClass().getName());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String peerId = stringArray[n2];
            IPeerNode peerNode = this.addCandidate(this.getPeerNode(peerId), filter, null);
            if (peerNode != null) {
                return peerNode;
            }
            ++n2;
        }
        return null;
    }

    private IPeerNode addCandidate(IPeerNode peerNode, IDefaultContextService.IContextFilter filter, List<IPeerNode> candidates) {
        if (peerNode != null && peerNode.isVisible() && (filter == null || filter.select(peerNode))) {
            if (candidates != null && !candidates.contains(peerNode)) {
                candidates.add(peerNode);
            }
            return peerNode;
        }
        return null;
    }

    private void addCandidates(IStructuredSelection selection, IDefaultContextService.IContextFilter filter, List<IPeerNode> candidates) {
        if (selection != null) {
            Iterator it = selection.iterator();
            while (it.hasNext()) {
                this.addCandidate((IPeerNode)Platform.getAdapterManager().getAdapter(it.next(), IPeerNode.class), filter, candidates);
            }
        }
    }

    private void addCandidates(IPeerNode[] peerModels, IDefaultContextService.IContextFilter filter, List<IPeerNode> candidates) {
        IPeerNode[] iPeerNodeArray = peerModels;
        int n = peerModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPeerNode peerNode = iPeerNodeArray[n2];
            this.addCandidate(peerNode, filter, candidates);
            ++n2;
        }
    }

    private IPeerNode[] getDefaultSelections(IDefaultContextService.IContextFilter filter) {
        ArrayList<IPeerNode> candidates = new ArrayList<IPeerNode>();
        String[] stringArray = HistoryManager.getInstance().getHistory(((Object)((Object)this)).getClass().getName());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String peerId = stringArray[n2];
            this.addCandidate(this.getPeerNode(peerId), filter, candidates);
            ++n2;
        }
        return candidates.toArray(new IPeerNode[candidates.size()]);
    }

    private IPeerNode getPeerNode(final String peerId) {
        if (peerId != null) {
            final AtomicReference peerNode = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    IPeerModel model = ModelManager.getPeerModel();
                    Assert.isNotNull((Object)model);
                    peerNode.set(((IPeerModelLookupService)model.getService(IPeerModelLookupService.class)).lkupPeerModelById(peerId));
                }
            };
            if (Protocol.isDispatchThread()) {
                runnable.run();
            } else {
                Protocol.invokeAndWait((Runnable)runnable);
            }
            return (IPeerNode)peerNode.get();
        }
        return null;
    }

    private IStructuredSelection getEditorSelection() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null && window.getActivePage().getActiveEditor() != null) {
            return new StructuredSelection((Object)window.getActivePage().getActiveEditor().getEditorInput());
        }
        return null;
    }

    private IStructuredSelection getPartSelection(String partId) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null) {
            ISelection sel = null;
            sel = partId != null ? window.getActivePage().getSelection(partId) : window.getActivePage().getSelection();
            if (sel instanceof IStructuredSelection) {
                return (IStructuredSelection)sel;
            }
        }
        return null;
    }

    public void modelChanged(IPeerModel model, IPeerNode peerNode, boolean added) {
        if (!added) {
            IPeerNode defaultContext = this.getDefaultContext(null);
            EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)this, (Object)"changed", (Object)defaultContext, (Object)defaultContext));
        }
    }

    public void modelDisposed(IPeerModel model) {
    }

    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (activityManagerEvent.haveEnabledActivityIdsChanged()) {
            IPeerNode defaultContext = this.getDefaultContext(null);
            EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)this, (Object)"changed", (Object)defaultContext, (Object)defaultContext));
        }
    }
}

