/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.actions.TeamAction;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.LoggedOperation;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.utility.DefaultOperationWrapperFactory;
import org.eclipse.team.svn.ui.utility.ICancellableOperationWrapper;
import org.eclipse.team.svn.ui.utility.IOperationWrapperFactory;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;

public abstract class AbstractSVNTeamAction
extends TeamAction {
    private IWorkbenchWindow window;
    private Shell shell;
    private ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                AbstractSVNTeamAction.this.checkSelection((IStructuredSelection)selection);
            }
        }
    };

    public final boolean saveAllEditors(boolean confirm) {
        return IDE.saveAllEditors((IResource[])this.getOriginalSelectedResources(), (boolean)confirm);
    }

    public abstract boolean isEnabled();

    public abstract void runImpl(IAction var1);

    protected final void execute(final IAction action) throws InvocationTargetException, InterruptedException {
        ProgressMonitorUtility.doTaskExternal((IActionOperation)new AbstractActionOperation("Operation_CallMenuAction", SVNUIMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                if (AbstractSVNTeamAction.this.isEnabled()) {
                    if (AbstractSVNTeamAction.this.needsToSaveDirtyEditors() && !AbstractSVNTeamAction.this.saveAllEditors(AbstractSVNTeamAction.this.confirmSaveOfDirtyEditor())) {
                        return;
                    }
                    AbstractSVNTeamAction.this.runImpl(action);
                }
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }

    protected boolean needsToSaveDirtyEditors() {
        return false;
    }

    protected boolean confirmSaveOfDirtyEditor() {
        return true;
    }

    protected ICancellableOperationWrapper runBusy(IActionOperation operation) {
        return UIMonitorUtility.doTaskBusy(operation, this.getOperationWrapperFactory());
    }

    protected ICancellableOperationWrapper runScheduled(IActionOperation operation) {
        return UIMonitorUtility.doTaskScheduled(this.getTargetPart(), operation, this.getOperationWrapperFactory());
    }

    protected IOperationWrapperFactory getOperationWrapperFactory() {
        return new DefaultOperationWrapperFactory();
    }

    protected void handleException(Exception ex) {
        this.handle(ex, SVNUIMessages.getErrorString("Error_ActionFailed"), SVNUIMessages.Error_ActionFailed_Message);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        try {
            IStructuredSelection structuredSelection = null;
            if (selection instanceof ITextSelection) {
                IResource resource;
                IEditorPart part = this.getTargetPage().getActiveEditor();
                if (part != null && (resource = (IResource)part.getEditorInput().getAdapter(IResource.class)) != null && resource.getType() == 1) {
                    structuredSelection = new StructuredSelection((Object)resource);
                }
            } else if (selection instanceof IStructuredSelection) {
                structuredSelection = (IStructuredSelection)selection;
            }
            if (structuredSelection == null || structuredSelection.isEmpty()) {
                if (action != null) {
                    action.setEnabled(false);
                }
            } else {
                this.checkSelection(structuredSelection);
                super.selectionChanged(action, (ISelection)structuredSelection);
            }
        }
        catch (Throwable ex) {
            LoggedOperation.reportError((String)SVNUIMessages.getErrorString("Error_MenuEnablement"), (Throwable)ex);
        }
    }

    protected Shell getShell() {
        return this.shell != null ? this.shell : super.getShell();
    }

    public IWorkbenchWindow getWindow() {
        return this.window;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
        this.shell = this.window.getShell();
        this.window.getSelectionService().addPostSelectionListener(this.selectionListener);
    }

    public void dispose() {
        if (this.window != null) {
            this.window.getSelectionService().removePostSelectionListener(this.selectionListener);
        }
        super.dispose();
    }

    protected IResource[] getSelectedResources() {
        IResource[] resources;
        ArrayList<IResource> res = new ArrayList<IResource>();
        IResource[] iResourceArray = resources = super.getSelectedResources();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (!FileUtility.isNotSupervised((IResource)resource)) {
                res.add(resource);
            }
            ++n2;
        }
        return res.toArray(new IResource[0]);
    }

    protected IResource[] getOriginalSelectedResources() {
        return super.getSelectedResources();
    }

    protected abstract void checkSelection(IStructuredSelection var1);

    protected abstract IStructuredSelection getSelection();
}

