/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.repository.IRepositoryEditorInput;
import org.eclipse.team.svn.ui.repository.RepositoryFileEditorInput;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;

public class OpenRemoteFileOperation
extends AbstractActionOperation {
    public static final int OPEN_DEFAULT = 0;
    public static final int OPEN_EXTERNAL = 1;
    public static final int OPEN_INPLACE = 2;
    public static final int OPEN_SPECIFIED = 3;
    protected IRepositoryEditorInput[] inputs;
    protected IEditorPart[] editors;
    protected IRepositoryResourceProvider provider;
    protected int openType;
    protected String openWith;
    protected Class requiredDefaultEditorKind;

    public OpenRemoteFileOperation(IRepositoryResourceProvider provider, int openType) {
        this(provider, openType, openType == 3 ? "org.eclipse.ui.DefaultTextEditor" : null);
    }

    public OpenRemoteFileOperation(IRepositoryResourceProvider provider, int openType, String openWith) {
        this((IRepositoryEditorInput[])null, openType, openWith);
        this.provider = provider;
    }

    public OpenRemoteFileOperation(IRepositoryFile[] resources, int openType) {
        this(resources, openType, openType == 3 ? "org.eclipse.ui.DefaultTextEditor" : null);
    }

    public OpenRemoteFileOperation(IRepositoryFile[] resources, int openType, String openWith) {
        this(OpenRemoteFileOperation.asEditorInput(resources), openType, openWith);
    }

    public OpenRemoteFileOperation(IRepositoryEditorInput[] inputs, int openType) {
        this(inputs, openType, openType == 3 ? "org.eclipse.ui.DefaultTextEditor" : null);
    }

    public OpenRemoteFileOperation(IRepositoryEditorInput[] inputs, int openType, String openWith) {
        super("Operation_OpenFile", SVNUIMessages.class);
        this.inputs = inputs;
        this.openType = openType;
        this.openWith = openWith;
    }

    public Class getRequiredDefaultEditorKind() {
        return this.requiredDefaultEditorKind;
    }

    public void setRequiredDefaultEditorKind(Class requiredDefaultEditorKind) {
        this.requiredDefaultEditorKind = requiredDefaultEditorKind;
    }

    public IEditorPart[] getEditors() {
        return this.editors;
    }

    public IRepositoryEditorInput[] getRepositoryEditorInputs() {
        return this.inputs;
    }

    protected void runImpl(final IProgressMonitor monitor) throws Exception {
        if (this.provider != null) {
            if (!(this.provider.getRepositoryResources()[0] instanceof IRepositoryFile)) {
                return;
            }
            this.inputs = OpenRemoteFileOperation.asEditorInput(new IRepositoryFile[]{(IRepositoryFile)this.provider.getRepositoryResources()[0]});
        }
        this.editors = new IEditorPart[this.inputs.length];
        int i = 0;
        while (i < this.inputs.length) {
            final int current = i++;
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    OpenRemoteFileOperation.this.inputs[current].fetchContents(monitor);
                }
            }, monitor, this.inputs.length * 2);
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    OpenRemoteFileOperation.this.protectStep(new IUnprotectedOperation(){

                        public void run(IProgressMonitor monitor) throws Exception {
                            OpenRemoteFileOperation.this.openFile(current);
                        }
                    }, monitor, OpenRemoteFileOperation.this.inputs.length * 2);
                }
            });
        }
    }

    protected void openFile(int current) throws Exception {
        IRepositoryEditorInput input = this.inputs[current];
        IWorkbench workbench = SVNTeamUIPlugin.instance().getWorkbench();
        IEditorRegistry registry = workbench.getEditorRegistry();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        if (this.openType == 1) {
            IEditorDescriptor descriptor = registry.findEditor("org.eclipse.ui.systemExternalEditor");
            if (descriptor != null) {
                this.editors[current] = this.openEditor(page, descriptor.getId(), input);
            }
        } else if (this.openType == 2) {
            IEditorDescriptor descriptor = registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
            if (descriptor != null) {
                this.editors[current] = this.openEditor(page, descriptor.getId(), input);
            }
        } else if (this.openType == 3) {
            this.editors[current] = this.openEditor(page, this.openWith, input);
        } else {
            IContentType type;
            String fileName = input.getRepositoryResource().getName();
            IEditorDescriptor descriptor = registry.getDefaultEditor(fileName, type = Platform.getContentTypeManager().findContentTypeFor(input.getStorage().getContents(), fileName));
            if (descriptor == null) {
                if (registry.isSystemInPlaceEditorAvailable(fileName)) {
                    descriptor = registry.findEditor("org.eclipse.ui.systemInPlaceEditor");
                } else if (registry.isSystemExternalEditorAvailable(fileName)) {
                    descriptor = registry.findEditor("org.eclipse.ui.systemExternalEditor");
                }
            }
            String editorId = descriptor == null ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
            try {
                this.editors[current] = this.openEditor(page, editorId, input);
                if (this.editors[current] != null && this.editors[current].getClass().getName().toLowerCase().indexOf("error") != -1 || this.requiredDefaultEditorKind != null && (this.editors[current] == null || !this.requiredDefaultEditorKind.isAssignableFrom(this.editors[current].getClass()))) {
                    this.editors[current] = this.openEditor(page, "org.eclipse.ui.DefaultTextEditor", input);
                }
            }
            catch (Throwable throwable) {
                this.editors[current] = this.openEditor(page, "org.eclipse.ui.DefaultTextEditor", input);
            }
        }
    }

    private final IEditorPart openEditor(IWorkbenchPage page, String editorId, IRepositoryEditorInput input) throws Exception {
        return page.openEditor((IEditorInput)input, editorId, true, 3);
    }

    protected static IRepositoryEditorInput[] asEditorInput(IRepositoryFile[] resources) {
        IRepositoryEditorInput[] inputs = new IRepositoryEditorInput[resources.length];
        int i = 0;
        while (i < resources.length) {
            inputs[i] = new RepositoryFileEditorInput(resources[i]);
            ++i;
        }
        return inputs;
    }
}

