/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.internal.ui.ProjectSetImporter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.wizards.PsfFilenameStore;
import org.eclipse.team.internal.ui.wizards.PsfUrlStore;
import org.eclipse.team.internal.ui.wizards.TeamWizardPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WorkingSetGroup;

public class ImportProjectSetMainPage
extends TeamWizardPage {
    Combo fileCombo;
    String file = "";
    Button browseButton;
    String urlString = "";
    Combo urlCombo;
    private Button fileInputButton;
    private Button urlInputButton;
    public static final int InputType_file = 0;
    public static final int InputType_URL = 1;
    private int inputType = 0;
    private boolean runInBackground = ImportProjectSetMainPage.isRunInBackgroundPreferenceOn();
    private int messageType = 0;
    private WorkingSetGroup workingSetGroup;
    private PsfFilenameStore psfFilenameStore = PsfFilenameStore.getInstance();
    private PsfUrlStore psfUrlStore = PsfUrlStore.getInstance();

    public ImportProjectSetMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(TeamUIMessages.ImportProjectSetMainPage_description);
    }

    private void setInputType(int inputTypeSelected) {
        this.inputType = inputTypeSelected;
        this.messageType = 0;
        this.fileInputButton.setSelection(this.inputType == 0);
        this.fileCombo.setEnabled(this.inputType == 0);
        this.browseButton.setEnabled(this.inputType == 0);
        this.urlInputButton.setSelection(this.inputType == 1);
        this.urlCombo.setEnabled(this.inputType == 1);
        if (this.inputType == 0) {
            this.updateFileEnablement();
        }
        if (this.inputType == 1) {
            this.updateUrlEnablement();
        }
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.initializeDialogUnits((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.ui.import_project_set_page_context");
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.fileInputButton = new Button(inner, 16);
        this.fileInputButton.setText(TeamUIMessages.ImportProjectSetMainPage_Project_Set_File);
        this.fileInputButton.setEnabled(true);
        this.fileInputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectSetMainPage.this.setInputType(0);
            }
        });
        this.fileCombo = this.createDropDownCombo(inner);
        this.file = this.psfFilenameStore.getSuggestedDefault();
        this.fileCombo.setItems(this.psfFilenameStore.getHistory());
        this.fileCombo.setText(this.file);
        this.fileCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ImportProjectSetMainPage.this.file = ImportProjectSetMainPage.this.fileCombo.getText();
                ImportProjectSetMainPage.this.updateFileEnablement();
            }
        });
        this.browseButton = new Button(inner, 8);
        this.browseButton.setText(TeamUIMessages.ImportProjectSetMainPage_Browse_3);
        this.urlInputButton = new Button(inner, 16);
        this.urlInputButton.setText(TeamUIMessages.ImportProjectSetMainPage_Project_Set_Url);
        this.urlInputButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectSetMainPage.this.setInputType(1);
            }
        });
        this.urlCombo = this.createDropDownCombo(inner);
        this.urlString = this.psfUrlStore.getSuggestedDefault();
        this.urlCombo.setItems(this.psfUrlStore.getHistory());
        this.urlCombo.setText(this.urlString);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.urlCombo.setLayoutData((Object)gd);
        this.urlCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ImportProjectSetMainPage.this.urlString = ImportProjectSetMainPage.this.urlCombo.getText();
                ImportProjectSetMainPage.this.updateUrlEnablement();
            }
        });
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        data.widthHint = Math.max(widthHint, this.browseButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.browseButton.setLayoutData((Object)data);
        this.browseButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FileDialog d = new FileDialog(ImportProjectSetMainPage.this.getShell());
                d.setFilterExtensions(new String[]{"*.psf", "*"});
                d.setFilterNames(new String[]{TeamUIMessages.ImportProjectSetMainPage_Project_Set_Files_2, TeamUIMessages.ImportProjectSetMainPage_allFiles});
                String fileName = ImportProjectSetMainPage.this.getFileName();
                if (fileName != null && fileName.length() > 0) {
                    int separator = fileName.lastIndexOf(System.getProperty("file.separator").charAt(0));
                    if (separator != -1) {
                        fileName = fileName.substring(0, separator);
                    }
                } else {
                    fileName = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
                }
                d.setFilterPath(fileName);
                String f = d.open();
                if (f != null) {
                    ImportProjectSetMainPage.this.fileCombo.setText(f);
                    ImportProjectSetMainPage.this.file = f;
                }
            }
        });
        this.addWorkingSetSection(composite);
        Button runInBackgroundCheckbox = SWTUtils.createCheckBox(composite, TeamUIMessages.ImportProjectSetMainPage_runInBackground, 3);
        runInBackgroundCheckbox.setSelection(ImportProjectSetMainPage.isRunInBackgroundPreferenceOn());
        runInBackgroundCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportProjectSetMainPage.this.runInBackground = !ImportProjectSetMainPage.this.runInBackground;
            }
        });
        this.setControl((Control)composite);
        this.setDefaultInputType();
        Dialog.applyDialogFont((Control)parent);
    }

    private void setDefaultInputType() {
        Control c = this.getControl();
        if (c != null) {
            Clipboard clipboard = new Clipboard(c.getDisplay());
            Object o = clipboard.getContents((Transfer)TextTransfer.getInstance());
            clipboard.dispose();
            if (o instanceof String) {
                try {
                    URL url = new URL((String)o);
                    if (url != null) {
                        this.setInputType(1);
                        this.urlCombo.setText((String)o);
                        return;
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        this.setInputType(0);
    }

    private void addWorkingSetSection(Composite composite) {
        this.workingSetGroup = new WorkingSetGroup(composite, null, new String[]{"org.eclipse.ui.resourceWorkingSetPage", "org.eclipse.jdt.ui.JavaWorkingSetPage"});
    }

    private void updateUrlEnablement() {
        boolean complete = false;
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this.urlString.length() == 0) {
            this.setMessage(TeamUIMessages.ImportProjectSetMainPage_specifyURL, this.messageType);
            complete = false;
        } else {
            try {
                new URL(this.urlString);
                complete = true;
            }
            catch (MalformedURLException malformedURLException) {
                this.messageType = 3;
                this.setMessage(TeamUIMessages.ImportProjectSetDialog_malformed_url, this.messageType);
                complete = false;
            }
        }
        if (complete) {
            this.setErrorMessage(null);
            this.setDescription(TeamUIMessages.ImportProjectSetMainPage_description);
        }
        this.setPageComplete(complete);
    }

    private void updateFileEnablement() {
        boolean complete = false;
        this.setMessage(null);
        this.setErrorMessage(null);
        if (this.file.length() == 0) {
            this.setMessage(TeamUIMessages.ImportProjectSetMainPage_specifyFile, this.messageType);
            this.setPageComplete(false);
            return;
        }
        File f = new File(this.file);
        if (!f.exists()) {
            this.messageType = 3;
            this.setMessage(TeamUIMessages.ImportProjectSetMainPage_The_specified_file_does_not_exist_4, this.messageType);
            this.setPageComplete(false);
            return;
        }
        if (f.isDirectory()) {
            this.messageType = 3;
            this.setMessage(TeamUIMessages.ImportProjectSetMainPage_You_have_specified_a_folder_5, this.messageType);
            this.setPageComplete(false);
            return;
        }
        if (!ProjectSetImporter.isValidProjectSetFile(this.file)) {
            this.messageType = 3;
            this.setMessage(TeamUIMessages.ImportProjectSetMainPage_projectSetFileInvalid, this.messageType);
            this.setPageComplete(false);
            return;
        }
        complete = true;
        if (complete) {
            this.setErrorMessage(null);
            this.setDescription(TeamUIMessages.ImportProjectSetMainPage_description);
        }
        this.setPageComplete(complete);
    }

    public String getFileName() {
        return this.file;
    }

    public String getUrl() {
        return this.urlString;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fileCombo.setFocus();
        }
    }

    public IWorkingSet[] getWorkingSets() {
        return this.workingSetGroup.getSelectedWorkingSets();
    }

    private static boolean isRunInBackgroundPreferenceOn() {
        return TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("org.eclipse.team.ui.run_import_in_background_");
    }

    public boolean isRunInBackgroundOn() {
        return this.runInBackground;
    }

    public int getInputType() {
        return this.inputType;
    }

    public String getURLContents() {
        try {
            PsfUrlStore.getInstance().remember(this.urlString);
            String urlContent = Utilities.getURLContents((URL)new URL(this.urlString), (IRunnableContext)this.getContainer());
            if (ProjectSetImporter.isValidProjectSetString(urlContent)) {
                return urlContent;
            }
            this.messageType = 3;
            this.setMessage(TeamUIMessages.ImportProjectSetMainPage_projectSetFileInvalid, this.messageType);
            this.setPageComplete(false);
            return null;
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            this.messageType = 3;
            this.setMessage(TeamUIMessages.ImportProjectSetMainPage_The_given_URL_cannot_be_loaded, this.messageType);
            this.setPageComplete(false);
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }
}

