/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.traceability;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.planning.SubPlan;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.viatra.query.runtime.rete.traceability.CompiledSubPlan;
import org.eclipse.viatra.query.runtime.rete.traceability.PatternTraceInfo;
import org.eclipse.viatra.query.runtime.rete.traceability.RecipeTraceInfo;

public class PlanningTrace
extends RecipeTraceInfo
implements PatternTraceInfo {
    protected SubPlan subPlan;
    protected List<PVariable> variablesTuple;
    protected Map<PVariable, Integer> posMapping;

    public PlanningTrace(SubPlan subPlan, List<PVariable> variablesTuple, ReteNodeRecipe recipe, Collection<? extends RecipeTraceInfo> parentRecipeTraces) {
        super(recipe, parentRecipeTraces);
        this.subPlan = subPlan;
        this.variablesTuple = variablesTuple;
        this.posMapping = new HashMap<PVariable, Integer>();
        int i = 0;
        while (i < variablesTuple.size()) {
            this.posMapping.put(variablesTuple.get(i), i);
            ++i;
        }
    }

    public PlanningTrace(SubPlan subPlan, List<PVariable> variablesTuple, ReteNodeRecipe recipe, RecipeTraceInfo ... parentRecipeTraces) {
        this(subPlan, variablesTuple, recipe, Arrays.asList(parentRecipeTraces));
    }

    public SubPlan getSubPlan() {
        return this.subPlan;
    }

    @Override
    public String getPatternName() {
        return this.subPlan.getBody().getPattern().getFullyQualifiedName();
    }

    public List<PVariable> getVariablesTuple() {
        return this.variablesTuple;
    }

    public Map<PVariable, Integer> getPosMapping() {
        return this.posMapping;
    }

    public CompiledSubPlan cloneFor(SubPlan newSubPlan) {
        return new CompiledSubPlan(newSubPlan, this.getVariablesTuple(), this.getRecipe(), this.getParentRecipeTraces());
    }
}

