/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.model.description.AbstractDescription;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.CreationInvocationDescription;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CreationDescription
extends AbstractDescription {
    private final ComponentDescription m_componentDescription;
    private final Class<?> m_componentClass;
    private final String m_componentClassName;
    private final String m_id;
    private Image m_icon;
    private final String m_name;
    private String m_description;
    private String m_source;
    private final List<CreationInvocationDescription> m_invocations = Lists.newArrayList();
    private final Map<String, String> m_parameters = Maps.newTreeMap();
    private Map<String, TypeParameterDescription> m_typeArguments;

    public CreationDescription(ComponentDescription componentDescription, String creationId, String name) {
        this.m_componentDescription = componentDescription;
        this.m_componentClass = componentDescription.getComponentClass();
        this.m_componentClassName = ReflectionUtils.getCanonicalName(this.m_componentClass);
        this.m_id = creationId;
        this.m_name = name != null ? name : CodeUtils.getShortClass(this.m_componentClassName);
    }

    public String getId() {
        return this.m_id;
    }

    public Image getIcon() {
        return this.m_icon != null ? this.m_icon : this.m_componentDescription.getIcon();
    }

    public void setIcon(Image icon) {
        this.m_icon = icon;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description != null ? this.m_description : this.m_componentDescription.getDescription();
    }

    public void setDescription(String description) {
        this.m_description = description != null ? StringUtilities.normalizeWhitespaces((String)description) : null;
    }

    public String getSource() {
        return this.m_source;
    }

    public void setSource(String source) {
        this.m_source = this.evaluate(source);
    }

    public List<CreationInvocationDescription> getInvocations() {
        return this.m_invocations;
    }

    public void addInvocation(CreationInvocationDescription invocation) {
        this.m_invocations.add(invocation);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.m_parameters);
    }

    public void addParameter(String name, String value) {
        this.m_parameters.put(name, value);
    }

    public Map<String, TypeParameterDescription> getTypeParameters() {
        return this.m_typeArguments != null ? this.m_typeArguments : ImmutableMap.of();
    }

    public void setTypeParameter(String name, String typeName, String title) {
        if (this.m_typeArguments == null) {
            this.m_typeArguments = Maps.newLinkedHashMap();
        }
        this.m_typeArguments.put(name, new TypeParameterDescription(typeName, title));
    }

    private String evaluate(String s) {
        return StringUtils.replace((String)s, (String)"%component.class%", (String)this.m_componentClassName);
    }

    public static class TypeParameterDescription {
        private final String m_typeName;
        private final String m_title;

        public TypeParameterDescription(String typeName, String title) {
            this.m_typeName = typeName;
            this.m_title = title;
        }

        public String getTypeName() {
            return this.m_typeName;
        }

        public String getTitle() {
            return this.m_title;
        }
    }
}

