/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.generic;

import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.generic.SimpleContainer;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.generic.SimpleContainerConfiguration;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleContainerConfigurable
implements SimpleContainer {
    private final XmlObjectInfo m_container;
    private final SimpleContainerConfiguration m_configuration;

    public SimpleContainerConfigurable(XmlObjectInfo container, SimpleContainerConfiguration configuration) {
        this.m_container = container;
        this.m_configuration = configuration;
    }

    public boolean isEmpty() {
        return this.getChild() == null;
    }

    public Object getChild() {
        for (ObjectInfo child : this.getContainerChildren()) {
            if (!this.validateComponent(child)) continue;
            return child;
        }
        return null;
    }

    public boolean validateComponent(Object component) {
        return this.m_configuration.getComponentValidator().validate((Object)this.m_container, component);
    }

    private List<ObjectInfo> getContainerChildren() {
        String signature = "getSimpleContainerChildren()";
        Method method = ReflectionUtils.getMethodBySignature(((Object)((Object)this.m_container)).getClass(), (String)signature);
        if (method != null) {
            return (List)ReflectionUtils.invokeMethodEx((Object)((Object)this.m_container), (String)signature, (Object[])new Object[0]);
        }
        return this.m_container.getChildren();
    }

    public void command_CREATE(Object newObject) throws Exception {
        if (!this.tryDuckTyping("command_CREATE", newObject)) {
            this.command_CREATE_default(newObject);
        }
        this.tryDuckTyping("command_CREATE_after", newObject);
        this.tryDuckTyping("command_TARGET_after", newObject);
    }

    public void command_ADD(Object moveObject) throws Exception {
        if (!this.tryDuckTyping("command_ADD", moveObject)) {
            this.command_ADD_default(moveObject);
        }
        this.tryDuckTyping("command_ADD_after", moveObject);
        this.tryDuckTyping("command_TARGET_after", moveObject);
    }

    private void command_CREATE_default(Object newObject) throws Exception {
        XmlObjectInfo component = (XmlObjectInfo)((Object)newObject);
        XmlObjectUtils.add(component, this.m_configuration.getAssociation(), this.m_container, null);
    }

    private void command_ADD_default(Object moveObject) throws Exception {
        XmlObjectInfo component = (XmlObjectInfo)((Object)moveObject);
        XmlObjectUtils.move(component, this.m_configuration.getAssociation(), this.m_container, null);
    }

    private boolean tryDuckTyping(String methodName, Object object) throws Exception {
        Method method = this.getCommandMethod(methodName, object);
        if (method != null) {
            method.invoke((Object)this.m_container, object);
            return true;
        }
        return false;
    }

    private Method getCommandMethod(String methodName, Object object) {
        Method[] methodArray = ((Object)((Object)this.m_container)).getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] parameterTypes;
            Method method = methodArray[n2];
            if (method.getName().equals(methodName) && (parameterTypes = method.getParameterTypes()).length == 1 && ReflectionUtils.isAssignableFrom(parameterTypes[0], (Object)object)) {
                return method;
            }
            ++n2;
        }
        return null;
    }
}

