/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.gef.GefMessages;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAlignmentActionsSupport<C extends IAbstractComponentInfo> {
    protected static final int ALIGN_H_LEFT = 1;
    protected static final int ALIGN_H_CENTERS = 2;
    protected static final int ALIGN_H_SPACE = 4;
    protected static final int ALIGN_H_RIGHT = 5;
    protected static final int ALIGN_V_TOP = 11;
    protected static final int ALIGN_V_CENTERS = 12;
    protected static final int ALIGN_V_SPACE = 14;
    protected static final int ALIGN_V_BOTTOM = 15;
    protected static final int ALIGN_WIDTH = 21;
    protected static final int ALIGN_HEIGHT = 22;
    protected static final int ALIGN_H_CENTER = 3;
    protected static final int ALIGN_V_CENTER = 13;
    protected List<C> m_components;

    public final void addAlignmentActions(List<ObjectInfo> objects, List<Object> actions) {
        if (objects.isEmpty()) {
            return;
        }
        IAbstractComponentInfo layoutContainer = this.getLayoutContainer();
        if (layoutContainer == null || objects.get(0).getParent() != layoutContainer.getUnderlyingModel()) {
            return;
        }
        this.m_components = Lists.newArrayList();
        for (ObjectInfo object : objects) {
            if (!this.isComponentInfo(object)) {
                return;
            }
            this.m_components.add((IAbstractComponentInfo)((Object)object));
        }
        HashSet parents = Sets.newHashSet();
        for (IAbstractComponentInfo component : this.m_components) {
            parents.add(component.getParent());
        }
        for (ObjectInfo object : objects) {
            if (!parents.contains(object)) continue;
            return;
        }
        this.fillActions(actions);
    }

    protected void fillActions(List<Object> actions) {
        this.addAlignmentActions(actions);
        this.addSizeActions(actions);
        this.addSpaceActions(actions);
        this.addCenterInContainerActions(actions);
    }

    protected void addAlignmentActions(List<Object> actions) {
        actions.add(new Separator());
        actions.add((Object)new SelectionAction("h_left", GefMessages.AbstractAlignmentActionsSupport_alignLeft, 1));
        actions.add((Object)new SelectionAction("h_centers", GefMessages.AbstractAlignmentActionsSupport_alighHorizontalCenters, 2));
        actions.add((Object)new SelectionAction("h_right", GefMessages.AbstractAlignmentActionsSupport_alignRight, 5));
        actions.add(new Separator());
        actions.add((Object)new SelectionAction("v_top", GefMessages.AbstractAlignmentActionsSupport_alignTop, 11));
        actions.add((Object)new SelectionAction("v_centers", GefMessages.AbstractAlignmentActionsSupport_alignVerticalCenters, 12));
        actions.add((Object)new SelectionAction("v_bottom", GefMessages.AbstractAlignmentActionsSupport_alignBottom, 15));
    }

    protected void addSpaceActions(List<Object> actions) {
        actions.add(new Separator());
        actions.add((Object)new SelectionAction("h_space", GefMessages.AbstractAlignmentActionsSupport_spaceEquallyHorizontal, 4));
        actions.add((Object)new SelectionAction("v_space", GefMessages.AbstractAlignmentActionsSupport_spaceEquallyVertical, 14));
    }

    protected void addSizeActions(List<Object> actions) {
        actions.add(new Separator());
        actions.add((Object)new SelectionAction("width", GefMessages.AbstractAlignmentActionsSupport_replicateWidth, 21));
        actions.add((Object)new SelectionAction("height", GefMessages.AbstractAlignmentActionsSupport_replicateHeight, 22));
    }

    protected void addCenterInContainerActions(List<Object> actions) {
        actions.add(new Separator());
        actions.add((Object)new SelectionAction("h_center", GefMessages.AbstractAlignmentActionsSupport_centerHorizontally, 3));
        actions.add((Object)new SelectionAction("v_center", GefMessages.AbstractAlignmentActionsSupport_centerVertically, 13));
    }

    protected abstract boolean isComponentInfo(ObjectInfo var1);

    protected final boolean isActionEnabled(int command) {
        if (this.m_components.size() == 1) {
            return command == 3 || command == 13;
        }
        if (command == 4 || command == 14) {
            ObjectInfo parent = ((IAbstractComponentInfo)this.m_components.get(0)).getParent();
            ListIterator<C> I = this.m_components.listIterator(1);
            while (I.hasNext()) {
                IAbstractComponentInfo component = (IAbstractComponentInfo)I.next();
                if (component.getParent() == parent) continue;
                return false;
            }
        }
        return true;
    }

    protected abstract void commandAlignLeft() throws Exception;

    protected abstract void commandAlignRight() throws Exception;

    protected abstract void commandAlignCenterHorizontally() throws Exception;

    protected abstract void commandAlignTop() throws Exception;

    protected abstract void commandAlignBottom() throws Exception;

    protected abstract void commandAlignCenterVertically() throws Exception;

    protected abstract void commandDistributeSpaceVertically() throws Exception;

    protected abstract void commandDistributeSpaceHorizontally() throws Exception;

    protected abstract void commandCenterVertically() throws Exception;

    protected abstract void commandCenterHorizontally() throws Exception;

    protected abstract void commandReplicateHeight() throws Exception;

    protected abstract void commandReplicateWidth() throws Exception;

    protected abstract IAbstractComponentInfo getLayoutContainer();

    protected class SelectionAction
    extends Action {
        private final int m_command;

        public SelectionAction(String image, String tooltip, int command) {
            this.m_command = command;
            String iconPath = "info/layout/absolute/align_" + image;
            this.setImageDescriptor(DesignerPlugin.getImageDescriptor(String.valueOf(iconPath) + ".gif"));
            this.setDisabledImageDescriptor(DesignerPlugin.getImageDescriptor(String.valueOf(iconPath) + "_disabled.gif"));
            this.setEnabled(AbstractAlignmentActionsSupport.this.isActionEnabled(this.m_command));
            this.setToolTipText(tooltip);
        }

        public void run() {
            ExecutionUtils.run(((IAbstractComponentInfo)AbstractAlignmentActionsSupport.this.m_components.get(0)).getUnderlyingModel(), new RunnableEx(){

                public void run() throws Exception {
                    switch (SelectionAction.this.m_command) {
                        case 3: {
                            AbstractAlignmentActionsSupport.this.commandCenterHorizontally();
                            break;
                        }
                        case 22: {
                            AbstractAlignmentActionsSupport.this.commandReplicateHeight();
                            break;
                        }
                        case 21: {
                            AbstractAlignmentActionsSupport.this.commandReplicateWidth();
                            break;
                        }
                        case 12: {
                            AbstractAlignmentActionsSupport.this.commandAlignCenterVertically();
                            break;
                        }
                        case 15: {
                            AbstractAlignmentActionsSupport.this.commandAlignBottom();
                            break;
                        }
                        case 11: {
                            AbstractAlignmentActionsSupport.this.commandAlignTop();
                            break;
                        }
                        case 2: {
                            AbstractAlignmentActionsSupport.this.commandAlignCenterHorizontally();
                            break;
                        }
                        case 5: {
                            AbstractAlignmentActionsSupport.this.commandAlignRight();
                            break;
                        }
                        case 1: {
                            AbstractAlignmentActionsSupport.this.commandAlignLeft();
                            break;
                        }
                        case 14: {
                            AbstractAlignmentActionsSupport.this.commandDistributeSpaceVertically();
                            break;
                        }
                        case 4: {
                            AbstractAlignmentActionsSupport.this.commandDistributeSpaceHorizontally();
                            break;
                        }
                        case 13: {
                            AbstractAlignmentActionsSupport.this.commandCenterVertically();
                            break;
                        }
                    }
                }
            });
        }
    }
}

