/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.ui.palette.PaletteCustomizer;
import org.eclipse.gef.ui.palette.customize.EntryPage;
import org.eclipse.wst.common.snippets.core.ISnippetCategory;
import org.eclipse.wst.common.snippets.core.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.editors.ISnippetEditor;
import org.eclipse.wst.common.snippets.internal.model.SnippetManager;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawer;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawerFactory;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItemFactory;
import org.eclipse.wst.common.snippets.internal.ui.SnippetDrawerEntryPage;
import org.eclipse.wst.common.snippets.internal.ui.SnippetTemplateEntryPage;

public class SnippetsCustomizer
extends PaletteCustomizer {
    protected List activeEditors = new ArrayList();
    protected List factories = null;
    private List deletedIds = new ArrayList();

    public SnippetsCustomizer() {
        this.factories = new ArrayList(2);
        this.factories.add(new SnippetPaletteDrawerFactory());
        this.factories.add(new SnippetPaletteItemFactory());
    }

    protected boolean canAdd(PaletteContainer container, PaletteEntry entry) {
        if (entry instanceof ISnippetCategory) {
            return super.canAdd(container, entry);
        }
        if (entry.getType().equals("$Palette Template")) {
            return container.getType().equals(PaletteDrawer.PALETTE_TYPE_DRAWER) && ((ISnippetsEntry)entry).getSourceType() != "PLUGINS" && super.canAdd(container, entry);
        }
        return ((ISnippetsEntry)entry).getSourceType() != "PLUGINS" && super.canAdd(container, entry);
    }

    public boolean canDelete(PaletteEntry entry) {
        return ((ISnippetsEntry)entry).getSourceType() != "PLUGINS" && super.canDelete(entry);
    }

    public boolean canExport(PaletteEntry entry) {
        return ((ISnippetsEntry)entry).getSourceType() != "PLUGINS" && entry.getType() == PaletteDrawer.PALETTE_TYPE_DRAWER;
    }

    public boolean canImport(PaletteEntry entry) {
        return true;
    }

    public boolean canMoveDown(PaletteEntry entry) {
        if (entry instanceof ISnippetCategory) {
            return super.canMoveDown(entry);
        }
        return ((ISnippetsEntry)entry).getSourceType() != "PLUGINS" && super.canMoveDown(entry);
    }

    public boolean canMoveUp(PaletteEntry entry) {
        if (entry instanceof ISnippetCategory) {
            return super.canMoveUp(entry);
        }
        return ((ISnippetsEntry)entry).getSourceType() != "PLUGINS" && super.canMoveUp(entry);
    }

    public List getNewEntryFactories() {
        return this.factories;
    }

    public EntryPage getPropertiesPage(PaletteEntry entry) {
        if (entry instanceof SnippetPaletteDrawer) {
            return new SnippetDrawerEntryPage();
        }
        if (entry instanceof SnippetPaletteItem && entry.getUserModificationPermission() == 15) {
            return new SnippetTemplateEntryPage(this);
        }
        return super.getPropertiesPage(entry);
    }

    public void revertToSaved() {
        this.activeEditors = new ArrayList(0);
        SnippetManager.getInstance().resetDefinitions();
    }

    public void save() {
        int i = 0;
        while (i < this.activeEditors.size()) {
            try {
                ((ISnippetEditor)this.activeEditors.get(i)).updateItem();
            }
            catch (Exception e) {
                Logger.logException(e);
            }
            ++i;
        }
        i = 0;
        while (i < this.deletedIds.size()) {
            IPath path = SnippetManager.getInstance().getStorageLocation(this.deletedIds.get(i).toString());
            File folder = new File(path.toOSString());
            this.deleteFolders(folder);
            ++i;
        }
        this.deletedIds.clear();
        this.activeEditors = new ArrayList(0);
        try {
            SnippetManager.getInstance().saveDefinitions();
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    private void deleteFolders(File folder) {
        if (!folder.exists()) {
            return;
        }
        File[] listFiles = folder.listFiles();
        int i = 0;
        while (i < listFiles.length) {
            if (listFiles[i].isDirectory()) {
                this.deleteFolders(listFiles[i]);
            } else {
                listFiles[i].delete();
            }
            ++i;
        }
        folder.delete();
    }

    public void performDelete(PaletteEntry entry) {
        this.deletedIds.add(entry.getId());
        super.performDelete(entry);
    }
}

