/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.monitor.ui.internal.viewers;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.internet.monitor.ui.internal.Messages;
import org.eclipse.wst.internet.monitor.ui.internal.MonitorUIPlugin;
import org.eclipse.wst.internet.monitor.ui.internal.provisional.ContentViewer;

public class BrowserViewer
extends ContentViewer {
    protected static final byte CR = 13;
    protected static final byte LF = 10;
    protected Browser browser;
    protected byte[] content;

    public void init(Composite parent) {
        this.browser = new Browser(parent, 0);
        this.browser.addListener(35, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
    }

    public void setContent(byte[] b) {
        this.content = b;
        if (b == null || b.length == 0) {
            this.browser.setText(Messages.htmlViewInvalid);
        } else {
            b = MonitorUIPlugin.unzip(b);
            int trimFront = 0;
            int trimBack = 0;
            int len = b.length - 1;
            while (trimFront < b.length && (b[trimFront] == 13 || b[trimFront] == 10)) {
                ++trimFront;
            }
            while (trimBack < b.length && b.length > 0 && (b[len - trimBack] == 13 || b[len - trimBack] == 10)) {
                ++trimBack;
            }
            if (trimFront + trimBack > 0) {
                if (trimFront + trimBack > b.length) {
                    b = new byte[]{};
                } else {
                    byte[] temp = b;
                    b = new byte[temp.length - trimBack - trimFront];
                    int i = trimFront;
                    while (i < temp.length - trimBack) {
                        b[i - trimFront] = temp[i];
                        ++i;
                    }
                }
            }
            this.browser.setText(new String(b));
        }
    }

    public byte[] getContent() {
        return this.content;
    }

    public void dispose() {
        this.browser.dispose();
        this.browser = null;
        this.content = null;
    }
}

