/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.protocolparser;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.wst.jsdt.chromium.internal.protocolparser.JsonValueCondition;

public abstract class EnumValueCondition<T extends Enum<T>>
implements JsonValueCondition<T> {
    private final Set<T> allowedValues;

    protected EnumValueCondition(Set<T> allowedValues) {
        this.allowedValues = allowedValues;
    }

    protected EnumValueCondition(T singleAllowedValues) {
        this.allowedValues = EnumSet.of(singleAllowedValues);
    }

    @Override
    public boolean conforms(T value) {
        return this.allowedValues.contains(value);
    }

    public static String decorateEnumConstantName(String enumValue) {
        return enumValue.toUpperCase().replace("-", "_");
    }
}

