/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11;

import org.eclipse.wst.wsdl.validation.internal.logging.LoggerFactory;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11Validator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidatorDelegate;

public class ClassloaderWSDL11ValidatorDelegate
extends WSDL11ValidatorDelegate {
    private String validatorClassname = null;
    private ClassLoader classLoader = null;

    public ClassloaderWSDL11ValidatorDelegate(String validatorClassname) {
        this.validatorClassname = validatorClassname;
    }

    public ClassloaderWSDL11ValidatorDelegate(String validatorClassname, ClassLoader classLoader) {
        this(validatorClassname);
        this.classLoader = classLoader;
    }

    protected IWSDL11Validator loadValidator() {
        IWSDL11Validator validator = null;
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
        }
        try {
            Class<?> validatorClass = this.classLoader != null ? this.classLoader.loadClass(this.validatorClassname) : Class.forName(this.validatorClassname);
            validator = (IWSDL11Validator)validatorClass.newInstance();
        }
        catch (Throwable t) {
            LoggerFactory.getInstance().getLogger().log("Unable to load validator " + this.validatorClassname, 0, t);
        }
        return validator;
    }
}

