/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public interface ILanguageServerAccess {
    public <T> CompletableFuture<T> doRead(String var1, Function<Context, T> var2);

    public void addBuildListener(IBuildListener var1);

    public LanguageClient getLanguageClient();

    @Data
    public static class Context {
        private final Resource resource;
        private final Document document;
        private final boolean isDocumentOpen;
        private final CancelIndicator cancelChecker;

        public Context(Resource resource, Document document, boolean isDocumentOpen, CancelIndicator cancelChecker) {
            this.resource = resource;
            this.document = document;
            this.isDocumentOpen = isDocumentOpen;
            this.cancelChecker = cancelChecker;
        }

        @Pure
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
            result = 31 * result + (this.document == null ? 0 : this.document.hashCode());
            result = 31 * result + (this.isDocumentOpen ? 1231 : 1237);
            result = 31 * result + (this.cancelChecker == null ? 0 : this.cancelChecker.hashCode());
            return result;
        }

        @Pure
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Context other = (Context)obj;
            if (this.resource == null ? other.resource != null : !this.resource.equals(other.resource)) {
                return false;
            }
            if (this.document == null ? other.document != null : !this.document.equals(other.document)) {
                return false;
            }
            if (other.isDocumentOpen != this.isDocumentOpen) {
                return false;
            }
            return !(this.cancelChecker == null ? other.cancelChecker != null : !this.cancelChecker.equals(other.cancelChecker));
        }

        @Pure
        public String toString() {
            ToStringBuilder b = new ToStringBuilder((Object)this);
            b.add("resource", (Object)this.resource);
            b.add("document", (Object)this.document);
            b.add("isDocumentOpen", (Object)this.isDocumentOpen);
            b.add("cancelChecker", (Object)this.cancelChecker);
            return b.toString();
        }

        @Pure
        public Resource getResource() {
            return this.resource;
        }

        @Pure
        public Document getDocument() {
            return this.document;
        }

        @Pure
        public boolean isDocumentOpen() {
            return this.isDocumentOpen;
        }

        @Pure
        public CancelIndicator getCancelChecker() {
            return this.cancelChecker;
        }
    }

    public static interface IBuildListener {
        public void afterBuild(List<IResourceDescription.Delta> var1);
    }
}

