/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hierarchy;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.ide.editor.hierarchy.DefaultHierarchyRoot;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyRoot;
import org.eclipse.xtext.ui.editor.hierarchy.DeferredHierarchyBuilder;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors(value={AccessorType.PUBLIC_SETTER, AccessorType.PROTECTED_GETTER})
public abstract class AbstractHierarchyViewPart
extends ViewPart {
    private IHierarchyBuilder builder;
    private URI rootURI;

    public void refresh(IProgressMonitor monitor) {
        this.setRoot(this.createRoot(monitor));
    }

    protected IHierarchyRoot createRoot(IProgressMonitor monitor) {
        if (this.builder == null || this.rootURI == null) {
            return IHierarchyRoot.EMPTY;
        }
        Collection roots = this.builder.buildRoots(this.rootURI, monitor);
        boolean _isEmpty = roots.isEmpty();
        if (_isEmpty) {
            return IHierarchyRoot.EMPTY;
        }
        DefaultHierarchyRoot root = new DefaultHierarchyRoot();
        List _roots = root.getRoots();
        Iterables.addAll((Collection)_roots, (Iterable)roots);
        return root;
    }

    protected abstract void setRoot(IHierarchyRoot var1);

    protected IHierarchyNode getSelectedNode(ISelection selection) {
        boolean _matched = false;
        if (selection instanceof IStructuredSelection) {
            boolean _equals;
            int _size = ((IStructuredSelection)selection).size();
            boolean bl = _equals = _size == 1;
            if (_equals) {
                _matched = true;
                Object selectedElement = ((IStructuredSelection)selection).getFirstElement();
                if (selectedElement instanceof IHierarchyNode) {
                    return (IHierarchyNode)selectedElement;
                }
            }
        }
        return null;
    }

    protected <T extends IHierarchyBuilder> T getBuilder(Class<T> clazz) {
        IHierarchyBuilder wrappedBuilder;
        boolean _isInstance_1;
        boolean _isInstance = clazz.isInstance(this.builder);
        if (_isInstance) {
            return (T)this.builder;
        }
        if (this.builder instanceof DeferredHierarchyBuilder && (_isInstance_1 = clazz.isInstance(wrappedBuilder = ((DeferredHierarchyBuilder)this.builder).getHierarchyBuilder()))) {
            return (T)wrappedBuilder;
        }
        return null;
    }

    @Pure
    protected IHierarchyBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(IHierarchyBuilder builder) {
        this.builder = builder;
    }

    @Pure
    protected URI getRootURI() {
        return this.rootURI;
    }

    public void setRootURI(URI rootURI) {
        this.rootURI = rootURI;
    }
}

