/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.gradle.api.UncheckedIOException;

public final class UncheckedException
extends RuntimeException {
    public UncheckedException(Throwable cause) {
        super(cause);
    }

    private UncheckedException(String message, Throwable cause) {
        super(message, cause);
    }

    public static RuntimeException throwAsUncheckedException(Throwable t) {
        return UncheckedException.throwAsUncheckedException(t, false);
    }

    public static RuntimeException throwAsUncheckedException(Throwable t, boolean preserveMessage) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof IOException) {
            if (preserveMessage) {
                throw new UncheckedIOException(t.getMessage(), t);
            }
            throw new UncheckedIOException(t);
        }
        if (preserveMessage) {
            throw new UncheckedException(t.getMessage(), t);
        }
        throw new UncheckedException(t);
    }

    public static RuntimeException unwrapAndRethrow(InvocationTargetException e) {
        return UncheckedException.throwAsUncheckedException(e.getTargetException());
    }
}

