/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.time;

import java.util.concurrent.TimeUnit;
import org.gradle.internal.time.TimeFormatting;
import org.gradle.internal.time.TimeSource;
import org.gradle.internal.time.Timer;

class DefaultTimer
implements Timer {
    private final TimeSource timeSource;
    private long startTime;

    DefaultTimer(TimeSource timeSource) {
        this.timeSource = timeSource;
        this.reset();
    }

    public String getElapsed() {
        long elapsedMillis = this.getElapsedMillis();
        return TimeFormatting.formatDurationVerbose(elapsedMillis);
    }

    public long getElapsedMillis() {
        long elapsedNanos = this.timeSource.nanoTime() - this.startTime;
        long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(elapsedNanos);
        return Math.max(elapsedMillis, 0L);
    }

    public void reset() {
        this.startTime = this.timeSource.nanoTime();
    }
}

