/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.jupiter.api.function.Executable;
import org.opentest4j.AssertionFailedError;

class AssertThrows {
    private AssertThrows() {
    }

    static <T extends Throwable> T assertThrows(Class<T> expectedType, Executable executable) {
        return AssertThrows.assertThrows(expectedType, executable, () -> null);
    }

    static <T extends Throwable> T assertThrows(Class<T> expectedType, Executable executable, String message) {
        return AssertThrows.assertThrows(expectedType, executable, () -> message);
    }

    static <T extends Throwable> T assertThrows(Class<T> expectedType, Executable executable, Supplier<String> messageSupplier) {
        try {
            executable.execute();
        }
        catch (Throwable actualException) {
            if (expectedType.isInstance(actualException)) {
                return (T)actualException;
            }
            String message = AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageSupplier)) + AssertionUtils.format(expectedType, actualException.getClass(), "Unexpected exception type thrown");
            throw new AssertionFailedError(message, actualException);
        }
        String message = AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageSupplier)) + String.format("Expected %s to be thrown, but nothing was thrown.", AssertionUtils.getCanonicalName(expectedType));
        throw new AssertionFailedError(message);
    }
}

