/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.ResourceLimitException;
import oracle.kv.impl.util.SerializationUtil;

public class TableSizeLimitException
extends ResourceLimitException {
    private static final long serialVersionUID = 1L;
    private final int tableSize;
    private final int tableSizeLimit;

    public TableSizeLimitException(String tableName, int tableSize, int tableSizeLimit, String msg) {
        super(tableName, msg);
        assert (tableName != null);
        this.tableSize = tableSize;
        this.tableSizeLimit = tableSizeLimit;
    }

    public TableSizeLimitException(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.tableSize = SerializationUtil.readPackedInt(in);
        this.tableSizeLimit = SerializationUtil.readPackedInt(in);
    }

    public int getTableSize() {
        return this.tableSize;
    }

    public int getTableSizeLimit() {
        return this.tableSizeLimit;
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        SerializationUtil.writePackedInt(out, this.tableSize);
        SerializationUtil.writePackedInt(out, this.tableSizeLimit);
    }
}

