/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.DoubleValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.Geometry;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.query.compiler.CompilerAPI;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.ExprFuncCall;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;

public class FuncGeoDistanceIter
extends PlanIter {
    private static final DoubleValueImpl theMinusOne = FieldDefImpl.doubleDef.createDouble(-1.0);
    private final PlanIter theLeftOp;
    private final PlanIter theRightOp;
    private final boolean theIsLeftConst;
    private final boolean theIsRightConst;

    public FuncGeoDistanceIter(Expr e, int resultReg, PlanIter[] argIters) {
        super(e, resultReg);
        this.theLeftOp = argIters[0];
        this.theRightOp = argIters[1];
        ExprFuncCall fncall = (ExprFuncCall)e;
        Expr larg = fncall.getArg(0);
        Expr rarg = fncall.getArg(1);
        this.theIsLeftConst = Expr.ConstKind.isConst(larg);
        this.theIsRightConst = Expr.ConstKind.isConst(rarg);
    }

    FuncGeoDistanceIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theLeftOp = FuncGeoDistanceIter.deserializeIter(in, serialVersion);
        this.theRightOp = FuncGeoDistanceIter.deserializeIter(in, serialVersion);
        this.theIsLeftConst = in.readBoolean();
        this.theIsRightConst = in.readBoolean();
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        FuncGeoDistanceIter.serializeIter(this.theLeftOp, out, serialVersion);
        FuncGeoDistanceIter.serializeIter(this.theRightOp, out, serialVersion);
        out.writeBoolean(this.theIsLeftConst);
        out.writeBoolean(this.theIsRightConst);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.GEO_DISTANCE;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new FuncGeoDistanceState());
        this.theLeftOp.open(rcb);
        this.theRightOp.open(rcb);
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theLeftOp.reset(rcb);
        this.theRightOp.reset(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theLeftOp.close(rcb);
        this.theRightOp.close(rcb);
        state.close();
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        FuncGeoDistanceState state = (FuncGeoDistanceState)rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        Geometry lgeom = null;
        Geometry rgeom = null;
        boolean haveNULL = false;
        if (state.theLeftGeom == null) {
            boolean leftOpNext = this.theLeftOp.next(rcb);
            if (leftOpNext) {
                FieldValueImpl lvalue = rcb.getRegVal(this.theLeftOp.getResultReg());
                if (lvalue.isNull()) {
                    haveNULL = true;
                } else {
                    lgeom = CompilerAPI.getGeoUtils().castAsGeometry(lvalue, state.sb);
                    if (this.theLeftOp.next(rcb)) {
                        lgeom = null;
                    }
                    if (this.theIsLeftConst) {
                        state.theLeftGeom = lgeom;
                    }
                }
            }
        } else {
            lgeom = state.theLeftGeom;
        }
        if (state.theRightGeom == null) {
            boolean rightOpNext = this.theRightOp.next(rcb);
            if (rightOpNext) {
                FieldValueImpl rvalue = rcb.getRegVal(this.theRightOp.getResultReg());
                if (rvalue.isNull()) {
                    haveNULL = true;
                } else {
                    rgeom = CompilerAPI.getGeoUtils().castAsGeometry(rvalue, state.sb);
                    if (this.theRightOp.next(rcb)) {
                        rgeom = null;
                    }
                    if (this.theIsRightConst) {
                        state.theRightGeom = rgeom;
                    }
                }
            }
        } else {
            rgeom = state.theRightGeom;
        }
        if (lgeom == null || rgeom == null) {
            rcb.setRegVal(this.theResultReg, theMinusOne);
            state.done();
            return true;
        }
        if (haveNULL) {
            rcb.setRegVal(this.theResultReg, NullValueImpl.getInstance());
            state.done();
            return true;
        }
        double res = lgeom.distance(rgeom, this.theLocation);
        rcb.setRegVal(this.theResultReg, FieldDefImpl.doubleDef.createDouble(res));
        state.done();
        return true;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theLeftOp.display(sb, formatter);
        sb.append(",\n");
        this.theRightOp.display(sb, formatter);
    }

    private static class FuncGeoDistanceState
    extends PlanIterState {
        Geometry theLeftGeom;
        Geometry theRightGeom;
        StringBuilder sb = new StringBuilder(256);

        private FuncGeoDistanceState() {
        }
    }
}

