/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.query.runtime;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.impl.api.table.StringValueImpl;
import oracle.kv.impl.query.compiler.Expr;
import oracle.kv.impl.query.compiler.QueryFormatter;
import oracle.kv.impl.query.runtime.PlanIter;
import oracle.kv.impl.query.runtime.PlanIterState;
import oracle.kv.impl.query.runtime.RuntimeControlBlock;
import oracle.kv.table.FieldValueFactory;

public class FuncParseJsonIter
extends PlanIter {
    private final PlanIter theInput;

    public FuncParseJsonIter(Expr e, int resultReg, PlanIter input) {
        super(e, resultReg);
        this.theInput = input;
    }

    FuncParseJsonIter(DataInput in, short serialVersion) throws IOException {
        super(in, serialVersion);
        this.theInput = FuncParseJsonIter.deserializeIter(in, serialVersion);
    }

    @Override
    public void writeFastExternal(DataOutput out, short serialVersion) throws IOException {
        super.writeFastExternal(out, serialVersion);
        FuncParseJsonIter.serializeIter(this.theInput, out, serialVersion);
    }

    @Override
    public PlanIter.PlanIterKind getKind() {
        return PlanIter.PlanIterKind.FUNC_PARSE_JSON;
    }

    @Override
    public void open(RuntimeControlBlock rcb) {
        rcb.setState(this.theStatePos, new PlanIterState());
        this.theInput.open(rcb);
    }

    @Override
    public void close(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state == null) {
            return;
        }
        this.theInput.close(rcb);
        state.close();
    }

    @Override
    public void reset(RuntimeControlBlock rcb) {
        this.theInput.reset(rcb);
        PlanIterState state = rcb.getState(this.theStatePos);
        state.reset(this);
    }

    @Override
    public boolean next(RuntimeControlBlock rcb) {
        PlanIterState state = rcb.getState(this.theStatePos);
        if (state.isDone()) {
            return false;
        }
        boolean more = this.theInput.next(rcb);
        if (!more) {
            state.done();
            return false;
        }
        FieldValueImpl val = rcb.getRegVal(this.theInput.getResultReg());
        if (val.isNull()) {
            rcb.setRegVal(this.theResultReg, NullValueImpl.getInstance());
            state.done();
            return true;
        }
        FieldValueImpl retval = (FieldValueImpl)FieldValueFactory.createValueFromJson(((StringValueImpl)val).get());
        rcb.setRegVal(this.theResultReg, retval);
        state.done();
        return true;
    }

    @Override
    protected void displayContent(StringBuilder sb, QueryFormatter formatter) {
        this.theInput.display(sb, formatter);
    }
}

